/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.utils;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.bean.RessourceBean;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Ressource;
import com.univ.utils.ContexteDao;
import com.univ.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UASOmHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(UASOmHelper.class);
    private static BeanUtilsBean beanUtils;

    public static void addAllRessourceMediaBean(ContexteDao contexteDao, List<RessourceBean> ressources, Map<String, MediaBean> medias, String pathImport) throws Exception {
        if (CollectionUtils.isNotEmpty(ressources) && MapUtils.isNotEmpty(medias)) {
            for (RessourceBean currentRessourceBean : ressources) {
                UASOmHelper.addRessourceBean(contexteDao, currentRessourceBean);
            }
        }
        if (MapUtils.isNotEmpty(medias)) {
            for (MediaBean currentMediaBean : medias.values()) {
                UASOmHelper.addMediaBean(contexteDao, currentMediaBean, pathImport);
            }
        }
    }

    public static void addAllMediaBean(ContexteDao contexteDao, Map<String, MediaBean> medias, String pathImport) throws Exception {
        if (MapUtils.isNotEmpty(medias)) {
            for (MediaBean currentMediaBean : medias.values()) {
                UASOmHelper.addMediaBean(contexteDao, currentMediaBean, pathImport);
            }
        }
    }

    public static void addMediaBean(OMContext ctx, MediaBean mediaBean, String pathImport) throws Exception {
        if (mediaBean != null) {
            Media currentMedia = new Media();
            currentMedia.init();
            currentMedia.setCtx(ctx);
            UASOmHelper.copyProperties(currentMedia, mediaBean);
            try {
                currentMedia.retrieve();
                return;
            }
            catch (Exception exception) {
                try {
                    if (UASOmHelper.saveMedia(currentMedia, pathImport)) {
                        currentMedia.add();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Erreur lors de l'upload du media " + currentMedia.getIdMedia(), (Throwable)e);
                }
            }
        }
    }

    private static boolean saveMedia(Media media, String pathImport) throws IOException {
        File file;
        String destination;
        File source;
        boolean save = Boolean.FALSE;
        if (media.isLocal()) {
            source = new File(pathImport, media.getUrl());
            if (source.exists()) {
                destination = MediathequeHelper.getAbsolutePath();
                if (StringUtils.isNotBlank((CharSequence)media.getTypeRessource())) {
                    destination = destination + File.separator + media.getTypeRessource().toLowerCase();
                }
                if ((file = new File(destination, media.getUrl())).exists()) {
                    String fileName = media.generateName(FileUtil.getExtension(media.getSource()));
                    media.setUrl(fileName);
                    file = new File(destination, media.getUrl());
                }
                FileUtils.copyFile((File)source, (File)file);
                save = true;
            }
        } else {
            save = true;
        }
        if (media.getUrlVignette().length() > 0) {
            source = new File(pathImport, media.getUrlVignette());
            if (source.exists()) {
                destination = MediathequeHelper.getAbsolutePath();
                if (media.getTypeRessource().length() > 0) {
                    destination = destination + File.separator + media.getTypeRessource().toLowerCase();
                }
                if ((file = new File(destination, media.getUrlVignette())).exists()) {
                    media.setUrlVignette("v_" + media.getUrl());
                    file = new File(destination, media.getUrlVignette());
                }
                FileUtils.copyFile((File)source, (File)file);
            } else {
                media.setUrlVignette("");
            }
        }
        return save;
    }

    public static void addRessourceBean(OMContext ctx, RessourceBean ressourceBean) throws Exception {
        if (ressourceBean != null) {
            Ressource currentRessource = new Ressource();
            currentRessource.init();
            UASOmHelper.copyProperties(currentRessource, ressourceBean);
            currentRessource.setCtx(ctx);
            currentRessource.add();
        }
    }

    public static void addMetatagBean(OMContext ctx, MetatagBean metaTagBean) throws Exception {
        if (metaTagBean != null) {
            Metatag metaTag = new Metatag();
            metaTag.init();
            UASOmHelper.copyProperties(metaTag, metaTagBean);
            metaTag.setCtx(ctx);
            metaTag.add();
        }
    }

    public static void copyProperties(Object object1, Object object2) throws IllegalAccessException, InvocationTargetException {
        beanUtils.copyProperties(object1, object2);
    }

    static {
        Object defaultValue = null;
        DateConverter converter = new DateConverter(defaultValue);
        beanUtils = BeanUtilsBean.getInstance();
        beanUtils.getConvertUtils().register((Converter)converter, Date.class);
    }
}

