/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.utils;

import com.jsbsoft.jtf.database.OMContext;
import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.cms.objetspartages.annotation.GetterAnnotationHelper;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.bean.FicheBeanExport;
import com.kportal.extension.module.bean.PluginFicheBeanExport;
import com.kportal.extension.module.service.ServiceBeanDeletion;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.kportal.extension.module.service.ServiceContenuModule;
import com.kportal.extension.module.utils.ServiceContenuModuleHelper;
import com.univ.objetspartages.bean.AbstractFicheBean;
import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.bean.RessourceBean;
import com.univ.objetspartages.om.AbstractFiche;
import com.univ.objetspartages.om.AbstractOm;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Ressource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UASServicesHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UASServicesHelper.class);

    public static List<RessourceBean> getRessources(Vector<Ressource> vRessources) {
        ArrayList<RessourceBean> ressources = new ArrayList<RessourceBean>();
        for (Ressource ressource : vRessources) {
            RessourceBean ressourceBean = new RessourceBean();
            try {
                UASOmHelper.copyProperties(ressourceBean, ressource);
                ressources.add(ressourceBean);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.error("impossible de copier le bean ressource", (Throwable)e);
            }
        }
        return ressources;
    }

    public static Map<String, MediaBean> getMediasByRessources(Collection<Ressource> vRessources, String pathExport) throws IllegalAccessException, InvocationTargetException, IOException {
        HashMap<String, MediaBean> medias = new HashMap<String, MediaBean>();
        boolean save = false;
        Iterator<Ressource> it = vRessources.iterator();
        while (it.hasNext()) {
            Ressource ressource = it.next();
            save = false;
            Media media = ressource.getMedia();
            save = UASServicesHelper.processMedia(media, pathExport);
            if (save) {
                MediaBean mediaBean = new MediaBean();
                UASOmHelper.copyProperties(mediaBean, media);
                medias.put(media.getIdMedia().toString(), mediaBean);
                continue;
            }
            it.remove();
        }
        return medias;
    }

    public static Map<String, MediaBean> getMedias(OMContext ctx, Object object, String pathExport) {
        return UASServicesHelper.getMedias(ctx, object, pathExport, Boolean.TRUE);
    }

    public static Map<String, MediaBean> getMedias(OMContext ctx, Object object, String pathExport, boolean inToolbox) {
        List<Method> methodIdMedia;
        List<Method> methodsToolBox;
        HashMap<String, MediaBean> listeMedias = new HashMap<String, MediaBean>();
        ArrayList<Long> listeIdMedias = new ArrayList<Long>();
        if (inToolbox && CollectionUtils.isNotEmpty(methodsToolBox = GetterAnnotationHelper.getMethodToolbox(object))) {
            for (Method method : methodsToolBox) {
                try {
                    Object contenuToolbox = method.invoke(object, new Object[0]);
                    if (!(contenuToolbox instanceof String) || contenuToolbox.equals("")) continue;
                    String[] listeIdFichiers = StringUtils.substringsBetween((String)((String)contenuToolbox), (String)"[id-fichier]", (String)"[/id-fichier]");
                    String[] listeIdImages = StringUtils.substringsBetween((String)((String)contenuToolbox), (String)"[id-image]", (String)"[/id-image]");
                    if (listeIdFichiers != null) {
                        for (String idMedia : listeIdFichiers) {
                            listeIdMedias.add(new Long(idMedia));
                        }
                    }
                    if (listeIdImages == null) continue;
                    for (String idMedia : listeIdImages) {
                        listeIdMedias.add(new Long(idMedia));
                    }
                }
                catch (Exception contenuToolbox) {
                }
            }
        }
        if (CollectionUtils.isNotEmpty(methodIdMedia = GetterAnnotationHelper.getMethodIdMedia(object))) {
            for (Method method : methodIdMedia) {
                try {
                    Object idMedia = method.invoke(object, new Object[0]);
                    Media media = new Media();
                    media.setCtx(ctx);
                    media.setIdMedia(new Long(idMedia.toString()));
                    media.retrieve();
                    listeIdMedias.add(media.getIdMedia());
                }
                catch (Exception exception) {}
            }
        }
        boolean save = false;
        for (Long idMedia : listeIdMedias) {
            try {
                save = false;
                Media media = new Media();
                media.setCtx(ctx);
                media.setIdMedia(idMedia);
                media.retrieve();
                save = UASServicesHelper.processMedia(media, pathExport);
                if (!save) continue;
                MediaBean mediaBean = new MediaBean();
                UASOmHelper.copyProperties(mediaBean, media);
                listeMedias.put(media.getIdMedia().toString(), mediaBean);
            }
            catch (Exception e) {
                LOGGER.error("Erreur lors de la recuperation d'un m\u00e9dia de contenu de toolbox", (Throwable)e);
            }
        }
        return listeMedias;
    }

    private static boolean processMedia(Media media, String pathExport) throws IOException {
        File destination;
        File source;
        boolean save = false;
        if (media.isLocal()) {
            source = new File(media.getPathAbsolu());
            if (source.exists()) {
                destination = new File(pathExport, media.getUrl());
                FileUtils.copyFile((File)source, (File)destination);
                save = true;
            }
        } else if (!media.getUrl().startsWith("/") && !media.getUrl().contains("\\")) {
            save = true;
        }
        if (media.getUrlVignette().length() > 0) {
            source = new File(media.getPathVignetteAbsolu());
            if (source.exists()) {
                destination = new File(pathExport, media.getUrlVignette());
                FileUtils.copyFile((File)source, (File)destination);
            } else {
                media.setUrlVignette("");
            }
        }
        return save;
    }

    public static <T extends Serializable> T getBean(Object object, Class<T> clazz) throws Exception {
        if (ClassUtils.isAssignable(object.getClass(), AbstractFiche.class)) {
            AbstractFiche fiche = (AbstractFiche)object;
            return (T)((Serializable)clazz.cast(fiche.getPersistenceBean()));
        }
        if (ClassUtils.isAssignable(object.getClass(), AbstractOm.class)) {
            AbstractOm om = (AbstractOm)object;
            return (T)((Serializable)clazz.cast(om.getPersistenceBean()));
        }
        Serializable clone = (Serializable)clazz.newInstance();
        UASOmHelper.copyProperties(clone, object);
        return (T)clone;
    }

    public static <T extends Serializable> Class<T> getBeanClass(Object object) {
        if (ClassUtils.isAssignable(object.getClass(), AbstractFiche.class)) {
            AbstractFiche fiche = (AbstractFiche)object;
            return ((AbstractFicheBean)fiche.getPersistenceBean()).getClass();
        }
        if (ClassUtils.isAssignable(object.getClass(), AbstractOm.class)) {
            AbstractOm om = (AbstractOm)object;
            return om.getPersistenceBean().getClass();
        }
        return UASServicesHelper.getOldParentBeanClass(object.getClass());
    }

    public static <T extends Serializable> Class<T> getOldParentBeanClass(Class<?> clazz) {
        Iterator hierarchy = ClassUtils.hierarchy(clazz, (ClassUtils.Interfaces)ClassUtils.Interfaces.EXCLUDE).iterator();
        Class beanType = null;
        for (int counter = 0; hierarchy.hasNext() && counter < 3; ++counter) {
            beanType = (Class)hierarchy.next();
        }
        return beanType;
    }

    public static <T extends Serializable> FicheBeanExport<T> getFicheBeanExport(FicheUniv ficheUniv, Class<T> clazz) throws Exception {
        FicheBeanExport<T> beanExport = new FicheBeanExport<T>();
        beanExport.setBean(UASServicesHelper.getBean(ficheUniv, clazz));
        return beanExport;
    }

    public static <T extends Serializable> PluginFicheBeanExport<T> getPluginFicheBeanExport(Object objet, Class<T> clazz) throws Exception {
        PluginFicheBeanExport<T> beanExport = new PluginFicheBeanExport<T>();
        beanExport.setBean(UASServicesHelper.getBean(objet, clazz));
        return beanExport;
    }

    public static ServiceBeanExport<?> getServiceBeanExport(IModule module) {
        ServiceBeanExport<?> serviceARetourner = null;
        Collection<ServiceContenuModule> servicesModulesDisponibles = ServiceContenuModuleHelper.getServiceContenuModules();
        for (ServiceContenuModule serviceModuleDispo : servicesModulesDisponibles) {
            if (!serviceModuleDispo.getModules().contains(module)) continue;
            serviceARetourner = serviceModuleDispo.getServiceBeanExport();
        }
        return serviceARetourner;
    }

    public static ServiceBeanImport<?> getServiceBeanImport(IModule module) {
        ServiceBeanImport<?> serviceARetourner = null;
        Collection<ServiceContenuModule> servicesModulesDisponibles = ServiceContenuModuleHelper.getServiceContenuModules();
        for (ServiceContenuModule serviceModuleDispo : servicesModulesDisponibles) {
            if (!serviceModuleDispo.getModules().contains(module)) continue;
            serviceARetourner = serviceModuleDispo.getServiceBeanImport();
        }
        return serviceARetourner;
    }

    public static ServiceBeanDeletion getServiceBeanSuppression(IModule module) {
        ServiceBeanDeletion serviceARetourner = null;
        Collection<ServiceContenuModule> servicesModulesDisponibles = ServiceContenuModuleHelper.getServiceContenuModules();
        for (ServiceContenuModule serviceModuleDispo : servicesModulesDisponibles) {
            if (!serviceModuleDispo.getModules().contains(module)) continue;
            serviceARetourner = serviceModuleDispo.getServiceBeanDeletion();
        }
        return serviceARetourner;
    }

    public static ServiceBeanReference getServiceBeanReference(IModule module) {
        ServiceBeanReference serviceARetourner = null;
        Collection<ServiceContenuModule> servicesModulesDisponibles = ServiceContenuModuleHelper.getServiceContenuModules();
        for (ServiceContenuModule serviceModuleDispo : servicesModulesDisponibles) {
            if (!serviceModuleDispo.getModules().contains(module)) continue;
            serviceARetourner = serviceModuleDispo.getServiceBeanReference();
        }
        return serviceARetourner;
    }

    public static boolean hasAttachedService(IModule module) {
        return UASServicesHelper.getServiceBeanExport(module) != null;
    }
}

