/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.validation;

import com.kosmos.validation.message.LocaleMessageInterpolator;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.resourceloading.AggregateResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class ValidationUtils {
    public static <T> Set<ConstraintViolation<T>> validateBean(T objectToValidate, Locale currentLocale, String idExtension) {
        AggregateResourceBundleLocator bundleLocator = new AggregateResourceBundleLocator(Arrays.asList(idExtension, "ValidationMessages"));
        Configuration config = Validation.byDefaultProvider().configure();
        Validator validator = config.messageInterpolator((MessageInterpolator)new LocaleMessageInterpolator(currentLocale, (ResourceBundleLocator)bundleLocator)).buildValidatorFactory().getValidator();
        return validator.validate(objectToValidate, new Class[0]);
    }

    public static <T> Set<ConstraintViolation<T>> validateBean(T objectToValidate, Locale currentLocale) {
        Configuration config = Validation.byDefaultProvider().configure();
        config.messageInterpolator((MessageInterpolator)new LocaleMessageInterpolator(currentLocale));
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        return validator.validate(objectToValidate, new Class[0]);
    }

    public static <T> Set<ConstraintViolation<T>> validateBean(T objectToValidate) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        return validator.validate(objectToValidate, new Class[0]);
    }
}

