/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.validation.validator;

import com.kosmos.validation.constraint.PostalCode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class PostalCodeValidator
implements ConstraintValidator<PostalCode, String> {
    final Pattern postalCodePattern = Pattern.compile("^((0[1-9])|([1-8][0-9])|(9[0-8])|(2A)|(2B))[0-9]{3}$");

    public void initialize(PostalCode constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        Matcher matcher = this.postalCodePattern.matcher(value);
        return matcher.matches();
    }
}

