/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cache;

import com.kportal.cache.CacheUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public abstract class AbstractCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheManager.class);

    @Async
    public void asyncRefresh() {
        this.refresh();
    }

    public void refresh() {
        try {
            if (!CacheUtil.updateObjectValue(this.getCacheName(), this.getObjectKey(), this.getObjectToCache())) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            LOGGER.error("Erreur refresh du cache " + this.getCacheName(), (Throwable)e);
        }
    }

    public Object call() {
        return CacheUtil.getObjectValue(this.getCacheName(), this.getObjectKey());
    }

    public void flush() {
        if (!CacheUtil.flush(this.getCacheName(), this.getObjectKey())) {
            LOGGER.error("Erreur flush du cache " + this.getCacheName());
        }
    }

    public abstract Object getObjectToCache() throws Exception;

    public abstract String getCacheName();

    public abstract Object getObjectKey();
}

