/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cache;

import com.jsbsoft.jtf.database.OMContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class CacheDB {
    protected transient OMContext ctx = null;
    protected String qualifier = null;
    private ResultSet rs = null;
    private Long idCache = null;
    private String type = null;
    private Long date = null;

    public void setIdCache(Long idCache) {
        this.idCache = idCache;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public Long getIdCache() {
        return this.idCache;
    }

    public String getType() {
        return this.type;
    }

    public Long getDate() {
        return this.date;
    }

    public String toString() {
        return this.toString(".");
    }

    public String toString(String aSeparator) {
        String s = "" + this.getIdCache() + aSeparator + this.getType() + aSeparator + this.getDate();
        return s;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    private Connection getConnection() throws Exception {
        return this.ctx.getConnection();
    }

    public void add() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("insert into CACHE (ID_CACHE , TYPE , DATE) values (?, ?, ?)", 1);
            stmt.setObject(1, (Object)this.getIdCache(), -5);
            stmt.setObject(2, (Object)this.getType(), 12);
            stmt.setObject(3, (Object)this.getDate(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
            this.rs = stmt.getGeneratedKeys();
            this.rs.next();
            this.setIdCache(this.rs.getLong(1));
        }
    }

    public void delete() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("DELETE FROM CACHE WHERE ID_CACHE = ?");
            stmt.setObject(1, (Object)this.getIdCache(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public String getSQLBaseQuery() {
        return "select distinct T1.ID_CACHE, T1.TYPE, T1.DATE from " + StringUtils.defaultString((String)this.qualifier) + "CACHE T1 ";
    }

    public boolean nextItem() throws Exception {
        boolean res = false;
        try {
            if (this.rs.next()) {
                this.retrieveFromRS();
                res = true;
            }
        }
        catch (Exception e) {
            throw new Exception("ERROR_IN_METHOD nextItem()", e);
        }
        return res;
    }

    public void retrieve() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("SELECT T1.ID_CACHE, T1.TYPE, T1.DATE FROM CACHE T1 WHERE T1.ID_CACHE = ?");
            stmt.setObject(1, (Object)this.getIdCache(), -5);
            this.rs = stmt.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("retrieve : METHOD_NO_RESULTS");
            }
            this.retrieveFromRS();
        }
    }

    private void retrieveFromRS() throws Exception {
        try {
            this.setIdCache(this.rs.getLong(1));
            this.setType(this.rs.getString(2));
            this.setDate(this.rs.getLong(3));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
        }
    }

    public void select(String sqlSuffix) throws Exception {
        PreparedStatement stmt = null;
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
    }

    public void update() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("update CACHE set ID_CACHE = ?, TYPE = ?, DATE = ? where ID_CACHE = ?");
            stmt.setObject(1, (Object)this.getIdCache(), -5);
            stmt.setObject(2, (Object)this.getType(), 12);
            stmt.setObject(3, (Object)this.getDate(), -5);
            stmt.setObject(4, (Object)this.getIdCache(), -5);
            stmt.executeUpdate();
            stmt.close();
        }
    }

    public void setCtx(OMContext ctx) {
        this.ctx = ctx;
    }
}

