/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cache;

import com.kportal.extension.ExtensionManager;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.cache.CacheInfosSiteManager;
import com.univ.objetspartages.cache.CacheLibelleManager;
import com.univ.objetspartages.cache.CacheProfilDsiManager;
import com.univ.objetspartages.cache.CacheRoleManager;
import com.univ.objetspartages.cache.CacheRubriqueManager;
import com.univ.objetspartages.cache.CacheServiceManager;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheLoaderManager
extends Observable
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheLoaderManager.class);
    public CacheProfilDsiManager cacheProfilDsiManager;
    public CacheRoleManager cacheRoleManager;
    public CacheGroupeDsiManager cacheGroupeDsiManager;
    public CacheLibelleManager cacheLibelleManager;
    public CacheInfosSiteManager cacheInfosSiteManager;
    public CacheRubriqueManager cacheRubriqueManager;
    public CacheServiceManager cacheServiceManager;
    public ExtensionManager extensionManager;

    public void init() {
        this.extensionManager.addObserver(this);
    }

    public void refresh() {
        this.cacheRubriqueManager.refresh();
        this.cacheInfosSiteManager.refresh();
        this.cacheServiceManager.refresh();
        try {
            this.cacheLibelleManager.flushAll();
            this.cacheLibelleManager.getListeInfosLibelles();
            this.cacheLibelleManager.getListeTypesLibelles();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.cacheGroupeDsiManager.flush();
            this.cacheGroupeDsiManager.getListeGroupesDsi();
            this.cacheGroupeDsiManager.getListeRequetesGroupes();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.cacheRoleManager.flush();
            this.cacheRoleManager.getListeRoles();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.cacheProfilDsiManager.flush();
            this.cacheProfilDsiManager.getListeProfilsDsi();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setCacheProfilDsiManager(CacheProfilDsiManager cacheProfilDsiManager) {
        this.cacheProfilDsiManager = cacheProfilDsiManager;
    }

    public void setCacheRoleManager(CacheRoleManager cacheRoleManager) {
        this.cacheRoleManager = cacheRoleManager;
    }

    public void setCacheGroupeDsiManager(CacheGroupeDsiManager cacheGroupeDsiManager) {
        this.cacheGroupeDsiManager = cacheGroupeDsiManager;
    }

    public void setCacheLibelleManager(CacheLibelleManager cacheLibelleManager) {
        this.cacheLibelleManager = cacheLibelleManager;
    }

    public void setCacheInfosSiteManager(CacheInfosSiteManager cacheInfosSiteManager) {
        this.cacheInfosSiteManager = cacheInfosSiteManager;
    }

    public void setCacheRubriqueManager(CacheRubriqueManager cacheRubriqueManager) {
        this.cacheRubriqueManager = cacheRubriqueManager;
    }

    public void setCacheServiceManager(CacheServiceManager cacheServiceManager) {
        this.cacheServiceManager = cacheServiceManager;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refresh();
        this.setChanged();
        this.notifyObservers();
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

