/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cache;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class CacheUtil {
    public static final String ID_BEAN = "cacheManager";

    public static CacheManager getCacheManager() {
        return (CacheManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }

    public static void flushCache(String cacheName) {
        CacheManager cacheMgr = CacheUtil.getCacheManager();
        if (cacheMgr != null && cacheMgr.getCache(cacheName) != null) {
            cacheMgr.getCache(cacheName).removeAll();
        }
    }

    public static Object getObjectValue(String cacheName, Object keyValue) {
        CacheManager cacheMgr = CacheUtil.getCacheManager();
        if (cacheMgr != null && cacheMgr.getCache(cacheName) != null && cacheMgr.getCache(cacheName).get(keyValue) != null) {
            return cacheMgr.getCache(cacheName).get(keyValue).getObjectValue();
        }
        return null;
    }

    public static boolean updateObjectValue(String cacheName, Object keyValue, Object value) {
        CacheManager cacheMgr = CacheUtil.getCacheManager();
        if (cacheMgr != null) {
            cacheMgr.addCacheIfAbsent(cacheName);
            cacheMgr.getCache(cacheName).put(new Element(keyValue, value));
            return true;
        }
        return false;
    }

    public static boolean flush(String cacheName, Object objectKey) {
        CacheManager cacheMgr = CacheUtil.getCacheManager();
        if (cacheMgr != null && cacheMgr.getCache(cacheName) != null) {
            cacheMgr.getCache(cacheName).remove(objectKey);
            return true;
        }
        return false;
    }
}

