/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cache;

import com.jsbsoft.jtf.database.JDBCUtils;
import com.kportal.cache.Cache;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCache {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCache.class);

    public static Cache getCache(String type) throws SQLException {
        Cache cache = null;
        try (ContexteDao ctx = new ContexteDao();){
            if (JDBCUtils.existe(ctx.getConnection(), "CACHE")) {
                RequeteSQL req = new RequeteSQL();
                ClauseWhere clauseWhere = new ClauseWhere();
                if (StringUtils.isNotEmpty((CharSequence)type)) {
                    clauseWhere.setPremiereCondition(ConditionHelper.egalVarchar("T1.TYPE", type));
                }
                Cache c = new Cache();
                c.init();
                c.setCtx(ctx);
                c.select(req.where(clauseWhere).formaterRequete());
                if (c.nextItem()) {
                    cache = c;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Cache de type " + type + " introuvale", (Throwable)e);
        }
        return cache;
    }

    public static void addCache(Cache cache) {
        try (ContexteDao ctx = new ContexteDao();){
            if (JDBCUtils.existe(ctx.getConnection(), "CACHE")) {
                cache.setCtx(ctx);
                cache.add();
            } else {
                LOG.error("la table CACHE n'existe pas!");
            }
        }
        catch (Exception e) {
            LOG.error("Ajout du cache de type " + cache.getType() + " imposssible", (Throwable)e);
        }
    }

    public static boolean needToRefresh(HttpServletRequest request, String cle) throws Exception {
        String type = request.getServerName() + (request.getRequestURL().toString().contains(":" + request.getServerPort() + "/") ? ":" + request.getServerPort() : "") + "_" + cle;
        return ServiceCache.needToRefresh(type);
    }

    public static boolean needToRefresh(String type) throws Exception {
        Cache cache = ServiceCache.getCache(type);
        if (cache != null) {
            cache.delete();
            return true;
        }
        return false;
    }
}

