/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.captcha;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.captcha.image.Gimpy;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.FastHashMapCaptchaStore;
import com.octo.captcha.service.multitype.MultiTypeCaptchaService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CaptchaServlet
extends HttpServlet {
    private static final long serialVersionUID = -3833735545073866482L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String captchaId = httpServletRequest.getSession(Boolean.FALSE.booleanValue()).getId();
        if (httpServletRequest.getParameter("image") != null) {
            byte[] captchaChallengeAsJpeg = null;
            ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
            try {
                MultiTypeCaptchaService captchaService = (MultiTypeCaptchaService)ApplicationContextManager.getCoreContextBean("captchaService");
                BufferedImage image = captchaService.getImageChallengeForID(captchaId, httpServletRequest.getLocale());
                ImageIO.write((RenderedImage)image, "jpeg", jpegOutputStream);
            }
            catch (IllegalArgumentException e) {
                httpServletResponse.sendError(404);
                return;
            }
            catch (CaptchaServiceException e) {
                httpServletResponse.sendError(500);
                return;
            }
            captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
            httpServletResponse.setHeader("Cache-Control", "no-store");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setContentType("image/jpeg");
            ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
            responseOutputStream.write(captchaChallengeAsJpeg);
            responseOutputStream.flush();
            responseOutputStream.close();
        } else if (httpServletRequest.getParameter("audio") != null) {
            FastHashMapCaptchaStore captchaStore = (FastHashMapCaptchaStore)ApplicationContextManager.getCoreContextBean("captchaStore");
            Gimpy captcha = (Gimpy)captchaStore.getCaptcha(captchaId);
            String response = captcha.getResponse();
            File f = new File(WebAppUtil.getAbsolutePath() + PropertyHelper.getCoreProperty("captcha.audio_path") + response + ".mp3");
            if (f.exists()) {
                ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
                FileInputStream fis = new FileInputStream(f);
                httpServletResponse.setHeader("Cache-Control", "no-store");
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setHeader("Content-Disposition", "inline;filename=\"mot.mp3\"");
                httpServletResponse.setDateHeader("Expires", 0L);
                httpServletResponse.setContentType("audio/mpeg3");
                BufferedInputStream bis = new BufferedInputStream(fis);
                try {
                    int nbBytes;
                    byte[] buf = new byte[4096];
                    while ((nbBytes = bis.read(buf)) > 0) {
                        responseOutputStream.write(buf, 0, nbBytes);
                    }
                }
                finally {
                    responseOutputStream.flush();
                    responseOutputStream.close();
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
        }
    }
}

