/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cms.mail;

import com.kportal.cms.mail.MailNotificationFormater;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.core.config.MessageHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultMailNotificationFormater
implements MailNotificationFormater {
    public List<String> classes;

    @Override
    public String getMessageRetourMiseEnLigne(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta, Utilisateur validateur) throws Exception {
        FicheObjet ficheNonLisible = null;
        if (ficheUniv instanceof FicheObjet && !FicheAnnotationHelper.isFicheFrontOffice(ficheUniv)) {
            ficheNonLisible = (FicheObjet)ficheUniv;
            ficheUniv = ficheNonLisible.renvoyerFicheParente();
        }
        String nomObjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv));
        String url_fiche = UnivWebFmt.determinerUrlFiche(ContexteUtil.getContexteUniv(), nomObjet.toLowerCase(), ficheUniv.getCode(), ficheUniv.getLangue(), false);
        if (infoBean.get("ESPACE") != null && ((String)infoBean.get("ESPACE")).length() > 0) {
            url_fiche = url_fiche + (url_fiche.contains("?") ? "&" : "?") + "ESPACE=" + infoBean.get("ESPACE");
        }
        if (ficheNonLisible != null) {
            url_fiche = url_fiche + "#forum" + ficheNonLisible.getCode();
        }
        return String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.VALIDATED"), validateur.getPrenom(), validateur.getNom(), ficheUniv.getLibelleAffichable(), URLResolver.getAbsoluteUrl(url_fiche, ContexteUtil.getContexteUniv()));
    }

    @Override
    public String getMessageRetourNonValide(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta, Utilisateur validateur) throws Exception {
        String nomObjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv));
        String message = String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.REFUSED_NO_REASON"), validateur.getPrenom(), validateur.getNom(), ficheUniv.getLibelleAffichable());
        if (infoBean.get("MOTIF_RETOUR") != null && ((String)infoBean.get("MOTIF_RETOUR")).length() > 0) {
            message = String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.REFUSED"), validateur.getPrenom(), validateur.getNom(), ficheUniv.getLibelleAffichable(), infoBean.get("MOTIF_RETOUR"));
        }
        if ("1".equals(meta.getMetaSaisieFront()) && FicheAnnotationHelper.isSaisieFrontOffice(ficheUniv)) {
            String url_fiche = "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + ReferentielObjets.getExtension(ficheUniv) + "+&ACTION=MODIFIER&ID_FICHE=";
            url_fiche = url_fiche + ficheUniv.getIdFiche() + "&PROC=SAISIE_" + nomObjet.toUpperCase();
            if ("1".equals(meta.getMetaSaisieFront())) {
                url_fiche = url_fiche + "_FRONT&SAISIE_FRONT=TRUE";
            }
            if (infoBean.get("ESPACE") != null && ((String)infoBean.get("ESPACE")).length() > 0) {
                url_fiche = url_fiche + "&ESPACE=" + infoBean.get("ESPACE");
            }
            if (!"ANONYME".equals(ficheUniv.getCodeRedacteur())) {
                message = message + String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.REFUSED_MODIF_FRONT"), URLResolver.getAbsoluteUrl(url_fiche, ContexteUtil.getContexteUniv()));
            }
        } else {
            message = message + String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.REFUSED_MODIF_BACK"), URLResolver.getAbsoluteBoUrl("/adminsite/", ContexteUtil.getContexteUniv().getInfosSite()));
        }
        return message;
    }

    @Override
    public String getMessageDemandeValidation(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta, Utilisateur utilisateur_demandeur) throws Exception {
        String nomprenom = "";
        if (utilisateur_demandeur.getIdUtilisateur().equals(new Long(0L))) {
            String emailano;
            nomprenom = (String)infoBean.get("AUTEUR");
            if (StringUtils.isEmpty((CharSequence)nomprenom)) {
                nomprenom = MessageHelper.getCoreMessage("MAIL.NOTIFICATION.AN_ANON");
            }
            if (StringUtils.isNotEmpty((CharSequence)(emailano = (String)infoBean.get("EMAIL_AUTEUR")))) {
                nomprenom = nomprenom + " ( " + emailano + " )";
            } else {
                emailano = meta.getMetaMailAnonyme();
                if (StringUtils.isNotEmpty((CharSequence)emailano)) {
                    nomprenom = nomprenom + " ( " + emailano + " )";
                }
            }
        } else {
            nomprenom = utilisateur_demandeur.getPrenom() + " " + utilisateur_demandeur.getNom();
        }
        String codeObjet = (String)infoBean.get("CODE_OBJET");
        String codeEspace = infoBean.get("ESPACE") != null ? (String)infoBean.get("ESPACE") : "";
        String message = String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.VALIDATE"), nomprenom, ficheUniv.getLibelleAffichable(), URLResolver.getAbsoluteBoUrl("/adminsite/", ContexteUtil.getContexteUniv().getInfosSite()));
        if (FicheUnivMgr.isFicheCollaborative(ficheUniv) && StringUtils.isNotEmpty((CharSequence)codeEspace)) {
            String urlfiche = "/servlet/com.jsbsoft.jtf.core.SG?ACTION=MODIFIER&ID_FICHE=" + ficheUniv.getIdFiche() + "&PROC=SAISIE_" + ReferentielObjets.getNomObjet(codeObjet).toUpperCase() + "_FRONT&SAISIE_FRONT=TRUE&ESPACE=" + codeEspace + "&LIEN_DIRECT=TRUE";
            urlfiche = URLResolver.getAbsoluteUrl(urlfiche, ContexteUtil.getContexteUniv());
            message = String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.VALIDATE"), nomprenom, ficheUniv.getLibelleAffichable(), Espacecollaboratif.getIntitule(codeEspace), urlfiche);
        }
        return message;
    }

    @Override
    public String getMessageNotificationCollaboratif(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta, Utilisateur utilisateur) throws Exception {
        String codeEspace = (String)infoBean.get("ESPACE");
        FicheObjet ficheNonLisible = null;
        if (ficheUniv instanceof FicheObjet && !FicheAnnotationHelper.isFicheFrontOffice(ficheUniv)) {
            ficheNonLisible = (FicheObjet)ficheUniv;
            ficheUniv = ficheNonLisible.renvoyerFicheParente();
        }
        String codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
        String nomObjet = ReferentielObjets.getNomObjet(codeObjet);
        String url_fiche = UnivWebFmt.determinerUrlFiche(ContexteUtil.getContexteUniv(), nomObjet.toLowerCase(), ficheUniv.getCode(), ficheUniv.getLangue(), false);
        url_fiche = url_fiche + (url_fiche.contains("?") ? "&" : "?") + "ESPACE=" + codeEspace;
        if (ficheNonLisible != null) {
            url_fiche = url_fiche + "#forum" + ficheNonLisible.getCode();
        }
        String nomEspace = Espacecollaboratif.getEspace(codeEspace).getIntitule();
        return String.format(MessageHelper.getCoreMessage("ST_COLLABORATIF_MAIL_MESSAGE_NOTIFICATION"), utilisateur.getLibelle(), ficheUniv.getLibelleAffichable(), nomEspace, URLResolver.getAbsoluteUrl(url_fiche, ContexteUtil.getContexteUniv()));
    }

    @Override
    public String getMessageNotification(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta, Utilisateur utilisateur_demandeur) throws Exception {
        String codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
        String nomObjet = ReferentielObjets.getNomObjet(codeObjet);
        FicheObjet ficheNonLisible = null;
        if (ficheUniv instanceof FicheObjet && !FicheAnnotationHelper.isFicheFrontOffice(ficheUniv)) {
            ficheNonLisible = (FicheObjet)ficheUniv;
            ficheUniv = ficheNonLisible.renvoyerFicheParente();
            nomObjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv));
        }
        String url_fiche = UnivWebFmt.determinerUrlFiche(ContexteUtil.getContexteUniv(), nomObjet.toLowerCase(), ficheUniv.getCode(), ficheUniv.getLangue(), false);
        if (ficheNonLisible != null) {
            url_fiche = url_fiche + "#forum" + ficheNonLisible.getCode();
        }
        return String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION.ONLINE"), utilisateur_demandeur.getPrenom(), utilisateur_demandeur.getNom(), ficheUniv.getLibelleAffichable(), URLResolver.getAbsoluteUrl(url_fiche, ContexteUtil.getContexteUniv()));
    }

    @Override
    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }
}

