/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cms.objetspartages;

import com.jsbsoft.jtf.core.ClassBeanManager;
import com.jsbsoft.jtf.core.CodeLibelle;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginRechercheHelper;
import com.univ.objetspartages.om.RechercheExterne;
import com.univ.objetspartages.om.ReferentielObjets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjetPartageHelper {
    private static final String FICHE = "fiche";
    private static final String STYLE = "STYLE";
    private static final String STYLE_AFFICHAGE = "style_affichage";
    public static final String TEMPLATE_FICHE = "fiche";
    public static final String TEMPLATE_ENTETE_FICHE = "entete_fiche";
    public static final String TEMPLATE_SAISIE = "saisie";
    public static final String TEMPLATE_ENCADRE_RECHERCHE = "encadre_recherche";
    public static final String TEMPLATE_ENCADRE_AUTOFICHE = "encadre_fiche";
    public static final String TEMPLATE_REQUETE_RESULTAT = "requete_resultat";
    public static final String TEMPLATE_RECHERCHE_CALCUL = "recherche_calcul";
    public static final String TEMPLATE_RECHERCHE_RESULTAT = "recherche_resultat";
    public static final String TEMPLATE_RECHERCHE = "recherche";
    public static final String PATH_TEMPLATE_REQUETE_RESULTAT_DEFAULT = "default";

    public static String getTemplateObjet(String templateJsp, String objet) {
        String path = "";
        Objetpartage op = ReferentielObjets.getObjetByNom(objet);
        IExtension extension = null;
        if (op != null) {
            extension = ModuleHelper.getExtensionModule(op);
        } else if (objet.equals(PATH_TEMPLATE_REQUETE_RESULTAT_DEFAULT)) {
            extension = ExtensionHelper.getCoreExtension();
        }
        if (extension != null) {
            path = "/WEB-INF/jsp/" + objet + "/fo" + "/" + templateJsp + ".jsp";
            return ExtensionHelper.getTemplateExtension(extension.getId(), path, Boolean.TRUE);
        }
        return path;
    }

    public static Map<String, String> getStylesAffichage(String objet) {
        Objetpartage op = ReferentielObjets.getObjetByNom(objet);
        return CodeLibelle.lireTable(op.getIdExtension(), objet.toLowerCase() + "_" + STYLE_AFFICHAGE, null);
    }

    public static List<String> getCriteresRequete(String objet, boolean listeIncluse) {
        RechercheExterne bean;
        Objetpartage op = ReferentielObjets.getObjetByNom(objet);
        List<Object> criteres = new ArrayList<String>();
        Iterator<RechercheExterne> iterator = ClassBeanManager.getInstance().getBeanOfType(RechercheExterne.class).iterator();
        while (iterator.hasNext() && (criteres = (bean = iterator.next()).getCriteresRequete(objet.toUpperCase(), listeIncluse)).size() <= 0) {
        }
        if (listeIncluse) {
            if ("1".equals(PropertyHelper.getProperty(op.getIdExtension(), "fiche." + objet.toUpperCase() + "." + STYLE_AFFICHAGE))) {
                criteres.add(STYLE);
            }
            criteres.addAll(PluginRechercheHelper.getCriteresRequete(objet));
        }
        criteres.add("CODE_RUBRIQUE");
        criteres.add("CODE_RATTACHEMENT");
        return criteres;
    }
}

