/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cms.objetspartages;

import com.jsbsoft.jtf.core.ClassBeanManager;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.extension.module.AbstractBeanManager;
import com.kportal.extension.module.IModule;
import com.univ.objetspartages.cache.CacheStructureManager;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.IEtat;
import com.univ.objetspartages.om.StructureModele;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferentielManager
extends AbstractBeanManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReferentielManager.class);
    public static final String ID_BEAN = "referentielManager";
    private static Map<String, Objetpartage> objetsByCode = null;
    private static Map<String, String> codesObjetsByNom = null;
    private static Map<String, String> codesObjetsByClasse = null;
    private static Collection<String> codesObjetsStructure = null;
    private static List<String> codesObjetsTries = null;
    public CacheStructureManager cacheStructureManager;
    public List<String> etatsObjet = null;
    public List<String> etatsObjetFront = null;

    @Override
    public void refresh() {
        Collection<Objetpartage> objetsPartages = this.moduleManager.getModules(Objetpartage.class);
        objetsByCode = new HashMap<String, Objetpartage>();
        codesObjetsByNom = new HashMap<String, String>();
        codesObjetsByClasse = new HashMap<String, String>();
        codesObjetsStructure = new ArrayList<String>();
        for (IModule iModule : objetsPartages) {
            Objetpartage objet = (Objetpartage)iModule;
            String nomObjet = objet.getNomObjet().toLowerCase();
            String codeObjet = objet.getCodeObjet();
            if (objetsByCode.get(codeObjet) == null && codesObjetsByNom.get(nomObjet) == null) {
                block8: {
                    try {
                        Class<?> classeObjet = Class.forName(objet.getNomClasse());
                        if (!(classeObjet.newInstance() instanceof StructureModele)) break block8;
                        codesObjetsStructure.add(codeObjet);
                    }
                    catch (Exception e) {
                        LOG.error("La classe " + objet.getNomClasse() + " n'a pas pu \u00eatre instanci\u00e9e, l'objet " + nomObjet + " est ignor\u00e9");
                        continue;
                    }
                }
                objet.setNomObjet(nomObjet);
                objetsByCode.put(codeObjet, objet);
                codesObjetsByNom.put(nomObjet, codeObjet);
                codesObjetsByClasse.put(objet.getNomClasse(), codeObjet);
                continue;
            }
            LOG.warn("L'objet " + objet.getNomObjet() + " n'a pas \u00e9t\u00e9 charg\u00e9 car son code ou nom existe d\u00e9j\u00e0!");
        }
        codesObjetsTries = new ArrayList<String>(objetsByCode.keySet());
        Collections.sort(codesObjetsTries);
        this.etatsObjet = new ArrayList<String>();
        this.etatsObjetFront = new ArrayList<String>();
        for (EtatFiche etat : EtatFiche.values()) {
            this.etatsObjet.add(etat.getEtat());
            if (!etat.isFront()) continue;
            this.etatsObjetFront.add(etat.getEtat());
        }
        for (IEtat iEtat : ClassBeanManager.getInstance().getBeanOfType(IEtat.class)) {
            this.etatsObjet.add(iEtat.getEtat());
            if (!iEtat.isFront()) continue;
            this.etatsObjetFront.add(iEtat.getEtat());
        }
        try {
            this.cacheStructureManager.flush();
            this.cacheStructureManager.getListeStructures();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public Objetpartage getObjetByNom(String nom) {
        return objetsByCode.get(codesObjetsByNom.get(nom.toLowerCase()));
    }

    public Map<String, Objetpartage> getObjetsByCode() {
        return objetsByCode;
    }

    public Map<String, String> getCodesObjetsByNom() {
        return codesObjetsByNom;
    }

    public Map<String, String> getCodesObjetsByClasse() {
        return codesObjetsByClasse;
    }

    public Collection<String> getCodesObjetsStructure() {
        return codesObjetsStructure;
    }

    public List<String> getCodesObjetsTries() {
        return codesObjetsTries;
    }

    public CacheStructureManager getCacheStructureManager() {
        return this.cacheStructureManager;
    }

    public void setCacheStructureManager(CacheStructureManager cacheStructureManager) {
        this.cacheStructureManager = cacheStructureManager;
    }

    public List<String> getEtatsObjet() {
        return this.etatsObjet;
    }

    public List<String> getEtatsObjetFront() {
        return this.etatsObjetFront;
    }
}

