/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.cms.objetspartages.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.email.JSBMailbox;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.oi.ObjetMail;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Utilisateur;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvoiMail
extends ProcessusBean {
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_CONFIRMATION = "CONFIRMATION";
    private ObjetMail objetMail;
    private static final Logger LOG = LoggerFactory.getLogger(EnvoiMail.class);

    public EnvoiMail(InfoBean ciu) {
        super(ciu);
    }

    protected void preparerPRINCIPAL() throws Exception {
        String libelleMailto;
        String userCode = (String)this.getGp().getSessionUtilisateur().getInfos().get("CODE");
        if (userCode != null) {
            String from = Utilisateur.getAdresseMail(userCode);
            this.infoBean.set("FROM", from);
        }
        if ((libelleMailto = this.objetMail.getLibelle(this.getFicheUniv(this, this.infoBean.getString("MAILTO"), this.infoBean.getString("TYPE"), this.getLangue()))).length() == 0) {
            throw new Exception("Utilisateur inexistant");
        }
        this.infoBean.set("LIBELLE_MAILTO", libelleMailto);
        this.ecranLogique = ECRAN_PRINCIPAL;
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.ecranLogique = this.infoBean.getEcranLogique();
        this.action = this.infoBean.getString("ACTION");
        this.objetMail = (ObjetMail)ApplicationContextManager.getEveryContextBean(this.infoBean.getString("ID_BEAN"));
        if (StringUtils.isBlank((CharSequence)this.ecranLogique) && "CREER_MAIL".equals(this.action)) {
            this.preparerPRINCIPAL();
        } else if (ECRAN_PRINCIPAL.equals(this.ecranLogique)) {
            this.traiterPRINCIPAL();
        }
        this.infoBean.setEcranLogique(this.ecranLogique);
        return this.etat == 2;
    }

    protected void traiterPRINCIPAL() throws Exception {
        if (this.action.equals("ENREGISTRER")) {
            String from = (String)this.infoBean.get("FROM");
            String mailto = this.objetMail.getAdresse(this.getFicheUniv(this, this.infoBean.getString("MAILTO"), this.infoBean.getString("TYPE"), this.getLangue()));
            if (mailto.length() == 0) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "UTILISATEUR.ERREUR.INEXISTANT"));
            }
            String objet = (String)this.infoBean.get("SUJET");
            String message = (String)this.infoBean.get("MESSAGE");
            LOG.info("envoi mail de : " + from + " ip : " + this.infoBean.getString("#remote-addr") + " UA : " + this.infoBean.getString("#user-agent"));
            LOG.info("objet : " + objet);
            LOG.info("message : " + message);
            this.envoyerEmail(from, mailto, objet, message);
            this.infoBean.set("MESSAGE_CONFIRMATION", MessageHelper.getCoreMessage("ST_ENVOI_MAIL_MESSAGE_CONFIRMATION"));
            this.ecranLogique = ECRAN_CONFIRMATION;
        }
        if (StringUtils.isBlank((CharSequence)this.ecranLogique)) {
            this.etat = 2;
        }
    }

    private void envoyerEmail(String from, String to, String object, String content) {
        JSBMailbox mailbox = new JSBMailbox(false);
        try {
            mailbox.sendTxtMsg(from, to, object, content);
        }
        catch (Exception e) {
            LOG.error("Exception occurred", (Throwable)e);
        }
    }

    protected String getLangue() {
        String langue = this.infoBean.getString("LANGUE");
        return langue == null ? "0" : langue;
    }

    protected FicheUniv getFicheUniv(OMContext _ctx, String _code, String type, String _langue) throws Exception {
        int count;
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(type);
        ficheUniv.init();
        ficheUniv.setCtx(_ctx);
        if (StringUtils.isEmpty((CharSequence)_code)) {
            return ficheUniv;
        }
        if (StringUtils.isEmpty((CharSequence)_langue)) {
            _langue = "0";
        }
        if ((count = ficheUniv.selectCodeLangueEtat(_code, _langue, "0003")) == 0) {
            count = ficheUniv.selectCodeLangueEtat(_code, _langue, "");
        }
        if (count > 0) {
            ficheUniv.nextItem();
        }
        return ficheUniv;
    }
}

