/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core;

import com.univ.multisites.InfosSite;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorServlet
extends HttpServlet {
    private static final long serialVersionUID = 6792391717404684763L;
    private static final Logger LOG = LoggerFactory.getLogger(ErrorServlet.class);
    private static final String CONTENT_TYPE = "text/html";

    public void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        servletResponse.setContentType(CONTENT_TYPE);
        try {
            String referer;
            Object queryString;
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            int code = NumberUtils.toInt((String)servletRequest.getParameter("CODE"), (int)404);
            String urlDemandee = "";
            Object requestURI = servletRequest.getAttribute("javax.servlet.forward.request_uri");
            if (requestURI != null) {
                urlDemandee = requestURI.toString();
            }
            if ((queryString = servletRequest.getAttribute("javax.servlet.forward.query_string")) != null && StringUtils.isNotEmpty((CharSequence)urlDemandee)) {
                urlDemandee = urlDemandee + "?" + queryString.toString();
            }
            if ((referer = servletRequest.getHeader("referer")) == null || referer.contains(urlDemandee)) {
                LOG.error("Page introuvable : " + URLResolver.getAbsoluteUrl(urlDemandee, ctx));
                servletResponse.setStatus(code);
                InfosSite siteCourant = ctx.getInfosSite();
                String urlRelativeJspError = siteCourant.getJspFo() + "/error/" + code + ".jsp?URL_DEMANDEE=" + URLEncoder.encode(urlDemandee, "UTF-8");
                RequestDispatcher rd = this.getServletConfig().getServletContext().getRequestDispatcher(urlRelativeJspError);
                rd.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            } else {
                LOG.error("Contenu introuvable : " + urlDemandee);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

