/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.config;

import com.kportal.core.config.Langue;
import com.kportal.core.config.PropertyConfigurer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangueConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangueConfig.class);
    public static final String ID_BEAN = "langueConfig";
    public static final String DEFAULT_PATH = "/adminsite/images/langues/";
    public static final String DEFAULT_IMAGE_DRAPEAU = "drapeau.png";
    public int max_langue = 10;
    private Map<Integer, Langue> langues = null;
    private int indiceLangueBo = 0;

    public void init() {
        try {
            try {
                this.max_langue = Integer.parseInt(PropertyConfigurer.getProperty("application.max_langue"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.langues = new HashMap<Integer, Langue>();
            for (int i = 0; i < this.max_langue; ++i) {
                String language = PropertyConfigurer.getProperty("langue_" + i + ".language");
                if (StringUtils.isEmpty((CharSequence)language)) continue;
                String country = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyConfigurer.getProperty("langue_" + i + ".country"), (CharSequence)"");
                String url = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyConfigurer.getProperty("langue_" + i + ".url"), (CharSequence)(DEFAULT_PATH + language));
                Langue lb = new Langue(i, new Locale(language, country), url);
                this.langues.put(i, lb);
            }
            try {
                this.indiceLangueBo = Integer.parseInt(PropertyConfigurer.getProperty("application.langue_bo"));
            }
            catch (Exception i) {}
        }
        catch (Exception e) {
            LOGGER.error("Erreur dans l'initialisation des langues de l'application : v\u00e9rifier la configuration", (Throwable)e);
        }
    }

    public int getNbLangues() {
        return this.langues.size();
    }

    public Map<Integer, Langue> getLangues() {
        return this.langues;
    }

    public int getIndiceLangueBo() {
        return this.indiceLangueBo;
    }
}

