/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.config;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.core.config.MessageLoaderUtil;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MessageHelper.class);

    public static String getMessage(String idCtx, InfosSite infosSite, Locale locale, String key, boolean searchCore) {
        String res = "";
        if (StringUtils.isEmpty((CharSequence)idCtx)) {
            idCtx = "core";
        }
        if (locale == null || !LangueUtil.isActiveLocale(locale)) {
            locale = LangueUtil.getDefaultLocale();
        }
        try {
            IExtension extension = ExtensionHelper.getExtension(idCtx);
            if (extension != null && extension.getId().equals(idCtx)) {
                if (infosSite != null) {
                    if (StringUtils.isNotBlank((CharSequence)infosSite.getAlias())) {
                        res = extension.getMessage(locale, infosSite.getAlias() + "." + key);
                    }
                    if (StringUtils.isEmpty((CharSequence)res) && StringUtils.isNotBlank((CharSequence)infosSite.getCodeTemplate())) {
                        res = extension.getMessage(locale, infosSite.getCodeTemplate() + "." + key);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)res)) {
                    res = extension.getMessage(locale, key);
                }
                if (StringUtils.isEmpty((CharSequence)res)) {
                    if ("core".equals(idCtx)) {
                        LOG.debug("Chaine " + key + " absente des messages " + locale.getCountry());
                    }
                    if (!idCtx.equals("core") && searchCore) {
                        LOG.debug("Chaine " + key + " absente des messages " + locale.getCountry() + " pour l'extension id=" + idCtx + " recherche dans le core");
                        res = MessageHelper.getMessage("core", infosSite, locale, key, searchCore);
                    }
                    if (StringUtils.isEmpty((CharSequence)res) && !locale.getCountry().equals(LangueUtil.getDefaultLocale().getCountry())) {
                        res = MessageHelper.getMessage(idCtx, infosSite, LangueUtil.getDefaultLocale(), key, searchCore);
                    }
                }
            } else {
                res = MessageLoaderUtil.getMessage(idCtx, LangueUtil.getLanguageCountry(locale), key);
                if (StringUtils.isEmpty((CharSequence)res) && !idCtx.equals("core") && searchCore) {
                    res = MessageLoaderUtil.getMessage("core", LangueUtil.getLanguageCountry(locale), key);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static String getMessage(String idCtx, String key) {
        return MessageHelper.getMessage(idCtx, MessageHelper.getInfosSite(), MessageHelper.getLocale(), key, true);
    }

    public static String getMessage(String idCtx, Locale locale, String key) {
        return MessageHelper.getMessage(idCtx, MessageHelper.getInfosSite(), locale, key, true);
    }

    public static String getExtensionMessage(String idCtx, String key) {
        return MessageHelper.getMessage(idCtx, MessageHelper.getInfosSite(), MessageHelper.getLocale(), key, false);
    }

    public static String getExtensionMessage(String idCtx, Locale locale, String key) {
        return MessageHelper.getMessage(idCtx, MessageHelper.getInfosSite(), locale, key, false);
    }

    public static String getCoreMessage(String key) {
        return MessageHelper.getMessage("core", MessageHelper.getInfosSite(), MessageHelper.getLocale(), key, false);
    }

    public static String getCoreMessage(Locale locale, String key) {
        return MessageHelper.getMessage("core", MessageHelper.getInfosSite(), locale, key, false);
    }

    public static Properties getMessages(String idCtx, Locale locale) {
        return ExtensionHelper.getExtension(idCtx).getMessages(locale);
    }

    private static InfosSite getInfosSite() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx != null) {
            return ctx.getInfosSite();
        }
        return Site.getSitePrincipal();
    }

    private static Locale getLocale() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx != null) {
            return ctx.getLocale();
        }
        return LangueUtil.getDefaultLocale();
    }

    public static final Locale parseLocaleFromFileName(String fileName) {
        String localeName = StringUtils.substringAfter((String)fileName, (String)"_");
        while (localeName.indexOf("_") != -1 && localeName.split("_")[0].length() > 2) {
            localeName = StringUtils.substringAfter((String)localeName, (String)"_");
        }
        localeName = StringUtils.substringBeforeLast((String)localeName, (String)".");
        Locale locale = null;
        try {
            locale = LocaleUtils.toLocale((String)localeName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return locale;
    }

    public static boolean isValidLocale(String value) {
        Locale[] locales;
        for (Locale l : locales = Locale.getAvailableLocales()) {
            if (!value.equals(l.toString())) continue;
            return true;
        }
        return false;
    }
}

