/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.config;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.util.PropertyPlaceholderHelper;

public class MessageLoader
extends PropertyPlaceholderConfigurer {
    protected static final String ID_BEAN = "messageLoader";
    private Resource[] locations;
    private Map<String, Properties> properties;
    private PropertyPlaceholderHelper placeHolderHelper;

    public void init() throws IOException {
        this.placeHolderHelper = new PropertyPlaceholderHelper(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, this.ignoreUnresolvablePlaceholders);
        this.properties = this.mergePropertiesByLocale();
    }

    public Properties getProperties(String locale) {
        return this.properties.get(locale);
    }

    public void setLocations(Resource ... locs) {
        super.setLocations(locs);
        this.locations = locs;
    }

    protected Map<String, Properties> mergePropertiesByLocale() throws IOException {
        HashMap<String, Properties> hProperties = new HashMap<String, Properties>();
        HashMap hLocations = new HashMap();
        if (this.locations != null) {
            for (Resource location : this.locations) {
                String path = location.getFilename();
                String locale = StringUtils.substringAfter((String)path, (String)"_");
                while (locale.contains("_") && locale.split("_")[0].length() > 2) {
                    locale = StringUtils.substringAfter((String)locale, (String)"_");
                }
                if (!this.isValidLocale(locale = StringUtils.substringBeforeLast((String)locale, (String)"."))) continue;
                if (hLocations.get(locale) == null) {
                    hLocations.put(locale, new ArrayList());
                }
                ((List)hLocations.get(locale)).add(location);
            }
        }
        if (!hLocations.isEmpty()) {
            for (String locale : hLocations.keySet()) {
                List l = (List)hLocations.get(locale);
                super.setLocations(l.toArray(new Resource[l.size()]));
                hProperties.put(locale, this.mergeProperties());
            }
        }
        return hProperties;
    }

    boolean isValidLocale(String value) {
        Locale[] locales;
        for (Locale l : locales = Locale.getAvailableLocales()) {
            if (!value.equals(l.toString())) continue;
            return true;
        }
        return false;
    }

    public static MessageLoader getInstance() {
        return (MessageLoader)((Object)ApplicationContextManager.getCoreContextBean(ID_BEAN));
    }

    public synchronized void reload() throws IOException {
        this.properties = this.mergePropertiesByLocale();
    }

    public PropertyPlaceholderHelper getPlaceHolderHelper() {
        return this.placeHolderHelper;
    }
}

