/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.config;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.util.PropertyPlaceholderHelper;

public class PropertyConfigurer
extends PropertyPlaceholderConfigurer
implements ApplicationContextAware {
    protected static final String ID_BEAN = "propertyConfigurer";
    private static ApplicationContext applicationContext;
    private Properties properties;
    private PropertyPlaceholderHelper placeHolderHelper;
    private Resource[] locations;

    public Properties getProperties() {
        return this.properties;
    }

    public Resource[] getLocations() {
        return this.locations;
    }

    public void setLocations(Resource ... locs) {
        super.setLocations(locs);
        this.locations = locs;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        this.placeHolderHelper = new PropertyPlaceholderHelper(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, this.ignoreUnresolvablePlaceholders);
        super.processProperties(beanFactory, props);
        this.properties = props;
    }

    public synchronized void reload() throws IOException {
        this.properties = this.mergeProperties();
    }

    public static PropertyConfigurer getInstance() {
        return (PropertyConfigurer)((Object)applicationContext.getBean(ID_BEAN));
    }

    public PropertyPlaceholderHelper getPlaceHolderHelper() {
        return this.placeHolderHelper;
    }

    public static String getProperty(String key) {
        String message = PropertyConfigurer.getInstance().getProperties().getProperty(key);
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            return PropertyConfigurer.getInstance().getPlaceHolderHelper().replacePlaceholders(message, PropertyConfigurer.getInstance().getProperties());
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        applicationContext = appCtx;
    }
}

