/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.config;

import com.kportal.core.config.PropertyConfigurerUtil;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.univ.multisites.InfosSite;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyHelper.class);

    public static String getProperty(String idCtx, InfosSite infosSite, String key, boolean searchCore) {
        IExtension extension;
        String res = null;
        if (StringUtils.isEmpty((CharSequence)idCtx)) {
            idCtx = "core";
        }
        if ((extension = ExtensionHelper.getExtension(idCtx)) != null) {
            if (infosSite != null) {
                if (StringUtils.isNotBlank((CharSequence)infosSite.getAlias())) {
                    res = extension.getProperty(infosSite.getAlias() + "." + key);
                }
                if (StringUtils.isEmpty((CharSequence)res) && StringUtils.isNotBlank((CharSequence)infosSite.getCodeTemplate())) {
                    res = extension.getProperty(infosSite.getCodeTemplate() + "." + key);
                }
            }
            if (StringUtils.isEmpty(res)) {
                res = extension.getProperty(key);
            }
            if (StringUtils.isEmpty((CharSequence)res)) {
                LOG.debug("Propri\u00e9t\u00e9 " + key + " introuvable pour l'extension id=" + idCtx);
                if (!idCtx.equals("core") && searchCore) {
                    res = PropertyHelper.getProperty("core", infosSite, key, searchCore);
                }
            }
        } else {
            res = PropertyConfigurerUtil.getProperty(idCtx, key);
        }
        return res;
    }

    public static String getExtensionProperty(String idCtx, String key) {
        return PropertyHelper.getProperty(idCtx, PropertyHelper.getInfosSite(), key, false);
    }

    public static String getCoreProperty(String key) {
        return PropertyHelper.getProperty("core", PropertyHelper.getInfosSite(), key, true);
    }

    public static String getProperty(String idCtx, String key) {
        return PropertyHelper.getProperty(idCtx, PropertyHelper.getInfosSite(), key, true);
    }

    public static int getCorePropertyAsInt(String key, int defaultValue) {
        return PropertyHelper.getPropertyAsInt("core", key, defaultValue);
    }

    public static int getPropertyAsInt(String idCtx, String key, int defaultValue) {
        String value = PropertyHelper.getProperty(idCtx, PropertyHelper.getInfosSite(), key, true);
        int intValue = defaultValue;
        try {
            intValue = Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    public static double getCorePropertyAsDouble(String key, double defaultValue) {
        return PropertyHelper.getPropertyAsDouble("core", key, defaultValue);
    }

    public static double getPropertyAsDouble(String idCtx, String key, double defaultValue) {
        String value = PropertyHelper.getProperty(idCtx, PropertyHelper.getInfosSite(), key, true);
        double doubleValue = defaultValue;
        try {
            doubleValue = Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return doubleValue;
    }

    public static long getCorePropertyAsLong(String key, long defaultValue) {
        return PropertyHelper.getPropertyAsLong("core", key, defaultValue);
    }

    public static long getPropertyAsLong(String idCtx, String key, long defaultValue) {
        String value = PropertyHelper.getProperty(idCtx, PropertyHelper.getInfosSite(), key, true);
        long doubleValue = defaultValue;
        try {
            doubleValue = Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return doubleValue;
    }

    public static boolean getCorePropertyAsBoolean(String key) {
        return PropertyHelper.getPropertyAsBoolean("core", key);
    }

    public static boolean getPropertyAsBoolean(String idCtx, String key) {
        String value = PropertyHelper.getProperty(idCtx, PropertyHelper.getInfosSite(), key, true);
        return Boolean.valueOf(value);
    }

    public static Properties getProperties(String idCtx) {
        return ExtensionHelper.getExtension(idCtx).getProperties();
    }

    public static Properties getAllProperties() {
        Properties allProperties = new Properties();
        for (String idCtx : ExtensionHelper.getExtensionManager().getExtensions().keySet()) {
            allProperties.putAll((Map<?, ?>)PropertyHelper.getProperties(idCtx));
        }
        return allProperties;
    }

    private static InfosSite getInfosSite() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx != null) {
            return ctx.getInfosSite();
        }
        return null;
    }
}

