/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.context;

import com.jsbsoft.jtf.core.LogAppFilter;
import com.jsbsoft.jtf.core.SG;
import com.kosmos.usinesite.servlet.FichiersUASServlet;
import com.kportal.captcha.CaptchaServlet;
import com.kportal.core.ErrorServlet;
import com.kportal.core.config.PropertiesLoader;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.ihm.FrontOfficeFilter;
import com.kportal.pdf.PDFFilter;
import com.kportal.pdf.PDFServlet;
import com.kportal.scheduling.util.DownloaderServlet;
import com.kportal.servlet.KeepAliveServlet;
import com.univ.autocomplete.servlet.AutoCompletionServlet;
import com.univ.collaboratif.utils.LectureFichiergw;
import com.univ.datagrid.servlet.DatagridServlet;
import com.univ.datagrid.servlet.LienPopupServlet;
import com.univ.tree.servlet.JsTreeServlet;
import com.univ.url.ContentServlet;
import com.univ.url.RubriqueServlet;
import com.univ.utils.FileReaderServlet;
import com.univ.utils.LectureImageToolbox;
import com.univ.utils.filter.ContexteFilter;
import com.univ.utils.filter.ForwardContexteFilter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.filters.SetCharacterEncodingFilter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import ro.isdc.wro.http.WroContextFilter;
import ro.isdc.wro.http.WroFilter;

public class ContextLoaderListener
implements ServletContextListener {
    public static final String ERROR_SERVLET_NAME = "errorServlet";
    private static final String JTF_PROPERTIES_FILE = "jtf.properties";
    private static final String ENV_PROPERTIES_FILE = "env.properties";
    private static final String DEFAULT_RUBRIQUE_URL_PATTERN = "/";
    private static final String DEFAULT_MEDIA_URL_PATTERN = "/medias/*";
    private static final String DEFAULT_CONTENT_URL_PATTERN = "*.kjsp";
    public static final String MEDIA_URL_PATTERN = "media.url-pattern";
    private static final String RUBRIQUE_URL_PATTERN = "rubrique.url-pattern";
    private static final String CONTENT_URL_PATTERN = "content.url-pattern";
    private static final String PATH_ENV_PROPERTIES = "path.properties";
    private static final String ENV_ETOILE_PROPERTIES_FILE = "env*.properties";
    private static ServletContext context = null;

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public static void ajouterServlet(String servletName, Class<? extends HttpServlet> servletClass, int loadOnStartup, List<String> mapping) {
        ServletRegistration servletRegistration = context.getServletRegistration(servletName);
        if (servletRegistration == null) {
            ServletRegistration.Dynamic servlet = context.addServlet(servletName, servletClass);
            for (String urlMapping : mapping) {
                servlet.addMapping(new String[]{urlMapping});
            }
            if (loadOnStartup != -1) {
                servlet.setLoadOnStartup(loadOnStartup);
            }
        }
    }

    public static void ajouterServlet(HttpServlet declaration) {
        WebServlet conf = declaration.getClass().getAnnotation(WebServlet.class);
        if (conf != null) {
            ContextLoaderListener.ajouterServlet(conf.name(), declaration.getClass(), conf.loadOnStartup(), Arrays.asList(conf.urlPatterns()));
        }
    }

    public static void ajouterFilter(Filter filter) {
        WebFilter conf = filter.getClass().getAnnotation(WebFilter.class);
        if (conf != null) {
            HashMap<String, String> h = new HashMap<String, String>();
            if (conf.initParams().length > 0) {
                for (WebInitParam param : conf.initParams()) {
                    h.put(param.name(), param.value());
                }
            }
            HashMap<String, List<DispatcherType>> dispatchersByPattern = new HashMap<String, List<DispatcherType>>();
            for (String pattern : conf.urlPatterns()) {
                dispatchersByPattern.put(pattern, Arrays.asList(conf.dispatcherTypes()));
            }
            HashMap<String, List<DispatcherType>> dispatchersByServlet = new HashMap<String, List<DispatcherType>>();
            for (String servlet : conf.servletNames()) {
                dispatchersByServlet.put(servlet, Arrays.asList(conf.dispatcherTypes()));
            }
            ContextLoaderListener.ajouterFilter(conf.filterName(), filter.getClass(), dispatchersByPattern, dispatchersByServlet, h, conf.asyncSupported());
        }
    }

    private static void ajouterFilter(String filterName, Class<? extends Filter> filterClass, Map<String, List<DispatcherType>> dispatcherByPattern, Map<String, List<DispatcherType>> dispatchersByServlet, Map<String, String> parameters) {
        ContextLoaderListener.ajouterFilter(filterName, filterClass, dispatcherByPattern, dispatchersByServlet, Collections.emptyMap(), false);
    }

    public static void ajouterFilter(String filterName, Class<? extends Filter> filterClass, Map<String, List<DispatcherType>> dispatchersByPattern, Map<String, List<DispatcherType>> dispatchersByServlet, Map<String, String> parameters, boolean asyncSupported) {
        FilterRegistration filterRegistration = context.getFilterRegistration(filterName);
        if (filterRegistration == null) {
            FilterRegistration.Dynamic filter = context.addFilter(filterName, filterClass);
            if (parameters != null && MapUtils.isNotEmpty(parameters)) {
                filter.setInitParameters(parameters);
            }
            for (Map.Entry<String, List<DispatcherType>> pattern : dispatchersByPattern.entrySet()) {
                for (DispatcherType dispatcher : pattern.getValue()) {
                    filter.addMappingForUrlPatterns(EnumSet.of(dispatcher), false, new String[]{pattern.getKey()});
                }
            }
            for (Map.Entry<String, List<DispatcherType>> servlet : dispatchersByServlet.entrySet()) {
                for (DispatcherType dispatcher : servlet.getValue()) {
                    filter.addMappingForServletNames(EnumSet.of(dispatcher), false, new String[]{servlet.getKey()});
                }
            }
            if (asyncSupported) {
                filter.setAsyncSupported(asyncSupported);
            }
        }
    }

    public static void ajouterListener(EventListener listener) {
        context.addListener(listener);
    }

    public void contextInitialized(ServletContextEvent event) {
        context = event.getServletContext();
        this.initSystemProperties(context);
        ContextLoaderListener.ajouterServlet("contentServlet", ContentServlet.class, -1, Arrays.asList(System.getProperty(CONTENT_URL_PATTERN)));
        ContextLoaderListener.ajouterServlet("rubriqueServlet", RubriqueServlet.class, -1, Arrays.asList(System.getProperty(RUBRIQUE_URL_PATTERN)));
        ContextLoaderListener.ajouterServlet("sg", SG.class, -1, Arrays.asList("/servlet/com.jsbsoft.jtf.core.SG"));
        ContextLoaderListener.ajouterServlet("captchaServlet", CaptchaServlet.class, 0, Arrays.asList("/captcha"));
        ContextLoaderListener.ajouterServlet("uasServlet", FichiersUASServlet.class, 0, Arrays.asList(WebAppUtil.getRelatifFichiersSitesPath() + "*"));
        ContextLoaderListener.ajouterServlet("pdfServlet", PDFServlet.class, -1, Arrays.asList("/servlet/com.kportal.pdf.PDFServlet"));
        ContextLoaderListener.ajouterServlet("lectureFichiergw", LectureFichiergw.class, -1, Arrays.asList("/servlet/com.univ.collaboratif.utils.LectureFichiergw", System.getProperty(MEDIA_URL_PATTERN)));
        ContextLoaderListener.ajouterServlet("fileReaderServlet", FileReaderServlet.class, -1, Arrays.asList("/servlet/com.univ.utils.FileReaderServlet"));
        ContextLoaderListener.ajouterServlet("logFileDownloader", DownloaderServlet.class, -1, Arrays.asList("/servlet/com.kportal.scheduling.util.Downloader"));
        ContextLoaderListener.ajouterServlet("lectureImageToolbox", LectureImageToolbox.class, -1, Arrays.asList("/servlet/com.univ.utils.LectureImageToolbox"));
        ContextLoaderListener.ajouterServlet("datagridServlet", DatagridServlet.class, -1, Arrays.asList("/servlet/com.univ.datagrid.servlet.DatagridServlet"));
        ContextLoaderListener.ajouterServlet("autoCompletionServlet", AutoCompletionServlet.class, -1, Arrays.asList("/servlet/com.kportal.servlet.autoCompletionServlet/*"));
        ContextLoaderListener.ajouterServlet("lienPopupServlet", LienPopupServlet.class, -1, Arrays.asList("/servlet/com.kportal.servlet.LienPopupServlet"));
        ContextLoaderListener.ajouterServlet("jsTreeServlet", JsTreeServlet.class, -1, Arrays.asList("/servlet/com.kportal.servlet.JsTreeServlet/*"));
        ContextLoaderListener.ajouterServlet("keepAliveServlet", KeepAliveServlet.class, -1, Arrays.asList("/servlet/com.kportal.servlet.KeepAliveServlet"));
        ContextLoaderListener.ajouterServlet(ERROR_SERVLET_NAME, ErrorServlet.class, -1, Arrays.asList("/servlet/com.kportal.core.ErrorServlet"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashMap<String, List<DispatcherType>> dispatchersByPattern = new HashMap<String, List<DispatcherType>>();
        HashMap<String, List<DispatcherType>> dispatchersByServlet = new HashMap<String, List<DispatcherType>>();
        parameters.put("encoding", "UTF-8");
        dispatchersByPattern.put("/*", Arrays.asList(DispatcherType.REQUEST));
        ContextLoaderListener.ajouterFilter("setCharacterEncodingFilter", SetCharacterEncodingFilter.class, dispatchersByPattern, dispatchersByServlet, parameters, true);
        dispatchersByPattern.clear();
        parameters.clear();
        dispatchersByPattern.put("/*", Arrays.asList(DispatcherType.REQUEST));
        dispatchersByServlet.put(ERROR_SERVLET_NAME, Arrays.asList(DispatcherType.ERROR));
        ContextLoaderListener.ajouterFilter("contexteFilter", ContexteFilter.class, dispatchersByPattern, dispatchersByServlet, Collections.emptyMap());
        dispatchersByPattern.clear();
        dispatchersByServlet.clear();
        dispatchersByPattern.put("/*", Arrays.asList(DispatcherType.FORWARD));
        ContextLoaderListener.ajouterFilter("forwardContexteFilter", ForwardContexteFilter.class, dispatchersByPattern, dispatchersByServlet, Collections.emptyMap());
        dispatchersByPattern.clear();
        dispatchersByServlet.put("contentServlet", Arrays.asList(DispatcherType.REQUEST));
        dispatchersByServlet.put("rubriqueServlet", Arrays.asList(DispatcherType.REQUEST));
        ContextLoaderListener.ajouterFilter("pdfFilter", PDFFilter.class, dispatchersByPattern, dispatchersByServlet, Collections.emptyMap());
        dispatchersByServlet.clear();
        dispatchersByPattern.put("*.jsp", Arrays.asList(DispatcherType.REQUEST, DispatcherType.FORWARD));
        dispatchersByServlet.put(ERROR_SERVLET_NAME, Arrays.asList(DispatcherType.ERROR));
        ContextLoaderListener.ajouterFilter("frontOfficeFilter", FrontOfficeFilter.class, dispatchersByPattern, dispatchersByServlet, Collections.emptyMap());
        dispatchersByPattern.clear();
        dispatchersByServlet.clear();
        dispatchersByPattern.put("/wro/*", Arrays.asList(DispatcherType.REQUEST, DispatcherType.REQUEST));
        ContextLoaderListener.ajouterFilter("wroFilter", WroFilter.class, dispatchersByPattern, dispatchersByServlet, Collections.emptyMap());
        dispatchersByPattern.clear();
        dispatchersByPattern.put("/*", Arrays.asList(DispatcherType.REQUEST));
        dispatchersByServlet.put(ERROR_SERVLET_NAME, Arrays.asList(DispatcherType.ERROR));
        ContextLoaderListener.ajouterFilter("wroContextFilter", WroContextFilter.class, dispatchersByPattern, dispatchersByServlet, Collections.emptyMap());
        dispatchersByPattern.clear();
        dispatchersByServlet.clear();
        dispatchersByPattern.put("/*", Arrays.asList(DispatcherType.REQUEST));
        ContextLoaderListener.ajouterFilter("logAppFilter", LogAppFilter.class, dispatchersByPattern, dispatchersByServlet, Collections.emptyMap());
        dispatchersByPattern.clear();
    }

    private void initSystemProperties(ServletContext context) {
        System.setProperty(CONTENT_URL_PATTERN, DEFAULT_CONTENT_URL_PATTERN);
        System.setProperty(MEDIA_URL_PATTERN, DEFAULT_MEDIA_URL_PATTERN);
        System.setProperty(RUBRIQUE_URL_PATTERN, DEFAULT_RUBRIQUE_URL_PATTERN);
        GenericApplicationContext gctx = new GenericApplicationContext();
        Properties propsFromFile = new Properties();
        try {
            if (StringUtils.isNotEmpty((CharSequence)WebAppUtil.getConfDir())) {
                System.setProperty(PATH_ENV_PROPERTIES, "file:///" + WebAppUtil.getConfDir() + File.separator);
                System.setProperty(ENV_PROPERTIES_FILE, "file:///" + WebAppUtil.getConfDir() + File.separator + ENV_ETOILE_PROPERTIES_FILE);
            } else {
                System.setProperty(PATH_ENV_PROPERTIES, "classpath*:");
                System.setProperty(ENV_PROPERTIES_FILE, "classpath*:env*.properties");
            }
            Resource[] resources = gctx.getResources(System.getProperty(ENV_PROPERTIES_FILE));
            if (resources.length == 0) {
                resources = gctx.getResources("classpath*:jtf.properties");
            }
            if (resources.length > 0) {
                PropertiesLoader pl = new PropertiesLoader();
                pl.setLocations(resources);
                propsFromFile = pl.loadProperties();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String prop : propsFromFile.stringPropertyNames()) {
            System.setProperty(prop, propsFromFile.getProperty(prop));
        }
        this.setPropertiesNonSurchargeable();
    }

    private void setPropertiesNonSurchargeable() {
        System.setProperty("server.html_path", StringUtils.removeEnd((String)context.getRealPath(File.separator), (String)File.separator));
    }
}

