/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.logging;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import com.kportal.core.config.PropertyConfigurer;
import com.kportal.core.logging.LogHelper;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class DefaultRollingFileAppender
extends RollingFileAppender<ILoggingEvent> {
    public static final String DEFAULT_NAME = "WEBAPP";
    private String fileName = null;
    private boolean append = true;

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DefaultRollingFileAppender() {
        this.setName(DEFAULT_NAME);
    }

    public DefaultRollingFileAppender(String name) {
        this.fileName = name;
        this.setName(name);
    }

    public DefaultRollingFileAppender(String name, String fileName) {
        this.fileName = fileName;
        this.setName(name);
    }

    public void start() {
        this.initDefaultRollingFileAppender();
        super.setAppend(this.append);
        super.start();
    }

    public void initDefaultRollingFileAppender() {
        SizeAndTimeBasedFNATP timeTrigger;
        String fileName = this.getFileName();
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            fileName = PropertyConfigurer.getProperty("logs.defaultFile");
            this.setFileName(fileName);
        }
        fileName = LogHelper.getServerLogName(fileName);
        String logPath = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyConfigurer.getProperty("logs.path"), (CharSequence)((String)StringUtils.defaultIfEmpty((CharSequence)PropertyConfigurer.getProperty("server.html_path"), (CharSequence)System.getProperty("server.html_path")) + "/WEB-INF/logs"));
        this.setFile(logPath + File.separator + fileName + ".log");
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(PropertyConfigurer.getProperty("logs.layoutPattern"));
        encoder.setContext(this.getContext());
        if (StringUtils.isNotEmpty((CharSequence)PropertyConfigurer.getProperty("logs.maxSize"))) {
            timeTrigger = new SizeAndTimeBasedFNATP();
            timeTrigger.setMaxFileSize(PropertyConfigurer.getProperty("logs.maxSize"));
        } else {
            timeTrigger = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        }
        timeTrigger.setContext(this.getContext());
        TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
        policy.setContext(this.getContext());
        policy.setFileNamePattern(logPath + File.separator + fileName + ".log" + "." + PropertyConfigurer.getProperty("logs.fileNamePattern"));
        policy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)timeTrigger);
        if (StringUtils.isNotEmpty((CharSequence)PropertyConfigurer.getProperty("logs.maxHistory"))) {
            try {
                policy.setMaxHistory(Integer.parseInt(PropertyConfigurer.getProperty("logs.maxHistory")));
            }
            catch (Exception e) {
                System.err.println("La valeur de la propri\u00e9t\u00e9 \"logs.maxHistory\" n'est pas num\u00e9rique");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)PropertyConfigurer.getProperty("logs.cleanHistoryOnStart"))) {
            policy.setCleanHistoryOnStart("1".equals(PropertyConfigurer.getProperty("logs.cleanHistoryOnStart")));
        }
        timeTrigger.setTimeBasedRollingPolicy(policy);
        this.setEncoder((Encoder)encoder);
        this.setRollingPolicy((RollingPolicy)policy);
        this.setTriggeringPolicy((TriggeringPolicy)timeTrigger);
        policy.setParent((FileAppender)this);
        encoder.start();
        policy.start();
    }
}

