/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.processus.util;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.processus.bean.ActionManagerBean;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.PermissionBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ActionManagerUtil {
    private final Object obj;
    private final Class<?> clazz;
    private final List<Method> methods;
    private final HashMap<String, ActionManagerBean> actions = new HashMap();
    private String insufficientRightsMessage = "You are not allowed to do this.";
    private String invalidActionMessage = "This action is invalid.";
    private String inexistingMethodMessage = "This method does not exist.";
    private final AutorisationBean autorisations;

    public ActionManagerUtil(Object o, AutorisationBean autorisations) {
        this.obj = o;
        this.clazz = o.getClass();
        this.methods = Arrays.asList(this.clazz.getMethods());
        this.autorisations = autorisations;
    }

    public ActionManagerUtil register(String action, String methodName, List<PermissionBean> permissions) {
        ActionManagerBean amb = new ActionManagerBean();
        amb.setMethodName(methodName);
        amb.setPermissions(permissions);
        this.actions.put(action, amb);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(String action) throws Exception {
        if (!this.actions.containsKey(action)) throw new Exception(this.invalidActionMessage);
        ActionManagerBean amb = this.actions.get(action);
        if (!this.containsMethod(amb.getMethodName())) throw new Exception(this.inexistingMethodMessage);
        for (PermissionBean permission : amb.getPermissions()) {
            if (this.autorisations.possedePermission(permission)) continue;
            throw new ErreurApplicative(this.insufficientRightsMessage);
        }
        this.clazz.getMethod(amb.getMethodName(), new Class[0]).invoke(this.obj, new Object[0]);
    }

    protected boolean containsMethod(String name) {
        boolean r = false;
        for (Method m : this.methods) {
            if (!name.equals(m.getName())) continue;
            r = true;
        }
        return r;
    }

    public String getInsufficientRightsMessage() {
        return this.insufficientRightsMessage;
    }

    public void setInsufficientRightsMessage(String insufficientRightsMessage) {
        this.insufficientRightsMessage = insufficientRightsMessage;
    }

    public String getInvalidActionMessage() {
        return this.invalidActionMessage;
    }

    public void setInvalidActionMessage(String invalidActionMessage) {
        this.invalidActionMessage = invalidActionMessage;
    }

    public String getInexistingMethodMessage() {
        return this.inexistingMethodMessage;
    }

    public void setInexistingMethodMessage(String inexistingMethodMessage) {
        this.inexistingMethodMessage = inexistingMethodMessage;
    }
}

