/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.resources.optimizer.model;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.resource.ResourceType;

public class CustomGroupExtractor
implements GroupExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomGroupExtractor.class);
    public static final String ATTR_INCLUDE_PATH = "javax.servlet.include.servlet_path";
    public static final String PARAM_MINIMIZE = "minimize";

    public String getGroupName(HttpServletRequest request) {
        String groupName;
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be NULL!");
        }
        String includeUriPath = (String)request.getAttribute(ATTR_INCLUDE_PATH);
        String uri = request.getRequestURI();
        uri = includeUriPath != null ? includeUriPath : uri;
        String[] groupes = uri.split("/");
        String groupe = "";
        if (groupes.length == 4) {
            groupe = groupes[2];
        }
        return StringUtils.isEmpty((CharSequence)(groupName = groupe)) ? null : groupName;
    }

    public ResourceType getResourceType(HttpServletRequest request) {
        Validate.notNull((Object)request);
        String uri = request.getRequestURI();
        ResourceType type = null;
        try {
            type = ResourceType.get((String)this.getExtensionFromUri(uri));
        }
        catch (IllegalArgumentException e) {
            LOG.debug("[FAIL] Cannot identify resourceType for uri: " + uri);
        }
        return type;
    }

    private String getExtensionFromUri(String uri) {
        return FilenameUtils.getExtension((String)uri.replaceFirst("(.*)(;.*)", "$1"));
    }

    public String encodeGroupUrl(String groupName, ResourceType resourceType, boolean minimize) {
        return String.format("%s.%s?minimize=%s", groupName, resourceType.name().toLowerCase(), minimize);
    }

    public boolean isMinimized(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be NULL!");
        }
        String minimizeAsString = request.getParameter(PARAM_MINIMIZE);
        return !Context.get().getConfig().isDebug() || !"false".equalsIgnoreCase(minimizeAsString);
    }
}

