/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.resources.optimizer.model;

import com.kportal.core.config.MessageHelper;
import com.kportal.core.resources.optimizer.model.ResourceLangueDecorator;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.CoreExtension;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.input.AutoCloseInputStream;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;

public class CustomXmlModelFactory
extends XmlModelFactory {
    private static final String WRO_XML = "wro.xml";
    public static final String WRO_FILE = "classes/wro.xml";
    public static final String WRO_BO_FILE = "com/kportal/ihm/wro.xml";

    protected String getDefaultModelFilename() {
        return WRO_FILE;
    }

    public synchronized WroModel create() {
        WroModel modelWebApp = super.create();
        WroModelInspector inspectorWebApp = new WroModelInspector(modelWebApp);
        for (String groupName : inspectorWebApp.getGroupNames()) {
            Group webAppGroup = inspectorWebApp.getGroupByName(groupName);
            Locale locale = MessageHelper.parseLocaleFromFileName(groupName);
            for (Resource resource : inspectorWebApp.getGroupByName(groupName).getResources()) {
                if (locale == null) continue;
                CoreExtension core = ExtensionHelper.getCoreExtension();
                ResourceLangueDecorator resourceLocale = ResourceLangueDecorator.create(core, locale, core.getRelativePath() + resource.getUri(), resource.getType());
                ArrayList<Object> bind = new ArrayList<Object>();
                bind.add((Object)resourceLocale);
                webAppGroup.replace(resource, bind);
            }
        }
        XmlModelFactory importedModelFactoryBO = new XmlModelFactory(){

            protected InputStream getModelResourceAsStream() throws IOException {
                return new AutoCloseInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CustomXmlModelFactory.WRO_BO_FILE));
            }
        };
        WroModel modelBO = importedModelFactoryBO.create();
        WroModelInspector inspectorBO = new WroModelInspector(modelBO);
        for (String groupName : inspectorBO.getGroupNames()) {
            if (!inspectorWebApp.getGroupNames().contains(groupName)) {
                modelWebApp.addGroup(inspectorBO.getGroupByName(groupName));
                inspectorWebApp = new WroModelInspector(modelWebApp);
            }
            Group webAppGroup = inspectorWebApp.getGroupByName(groupName);
            Locale locale = MessageHelper.parseLocaleFromFileName(groupName);
            for (Resource resource : inspectorBO.getGroupByName(groupName).getResources()) {
                if (locale == null) continue;
                CoreExtension core = ExtensionHelper.getCoreExtension();
                ResourceLangueDecorator resourceLocale = ResourceLangueDecorator.create(core, locale, core.getRelativePath() + resource.getUri(), resource.getType());
                ArrayList<ResourceLangueDecorator> bind = new ArrayList<ResourceLangueDecorator>();
                bind.add(resourceLocale);
                webAppGroup.replace(resource, bind);
            }
        }
        for (IExtension extension : ExtensionHelper.getExtensionManager().getExtensions().values()) {
            String path = WebAppUtil.getClassPath() + extension.getId() + "_" + WRO_XML;
            if (!new File(path).exists() && !WebAppUtil.getExtensionClassPath(extension.getId()).equals(WebAppUtil.getClassPath())) {
                path = WebAppUtil.getExtensionClassPath(extension.getId()) + WRO_XML;
            }
            if (!new File(path).exists()) continue;
            final String wroPath = path;
            XmlModelFactory importedModelFactory = new XmlModelFactory(){

                protected InputStream getModelResourceAsStream() throws IOException {
                    return new AutoCloseInputStream((InputStream)new FileInputStream(wroPath));
                }
            };
            WroModel modelExtension = importedModelFactory.create();
            WroModelInspector inspectorExtension = new WroModelInspector(modelExtension);
            for (String groupName : inspectorExtension.getGroupNames()) {
                if (!inspectorWebApp.getGroupNames().contains(groupName)) {
                    modelWebApp.addGroup(inspectorExtension.getGroupByName(groupName));
                    inspectorWebApp = new WroModelInspector(modelWebApp);
                }
                Group webAppGroup = inspectorWebApp.getGroupByName(groupName);
                Locale locale = MessageHelper.parseLocaleFromFileName(groupName);
                for (Resource resource : inspectorExtension.getGroupByName(groupName).getResources()) {
                    Resource nextResource = locale != null ? ResourceLangueDecorator.create(extension, locale, extension.getRelativePath() + resource.getUri(), resource.getType()) : Resource.create((String)(extension.getRelativePath() + resource.getUri()), (ResourceType)resource.getType());
                    if (webAppGroup.getResources().contains(nextResource)) continue;
                    webAppGroup.addResource(nextResource);
                }
            }
        }
        return modelWebApp;
    }
}

