/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.resources.optimizer.processor;

import com.kportal.core.config.MessageHelper;
import com.kportal.core.resources.optimizer.model.ResourceLangueDecorator;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.WroUtil;

public class PropertyMatcherProcessor
implements ResourcePreProcessor {
    private static final Pattern PATTERN_PLACEHOLDER = Pattern.compile(WroUtil.loadRegexpWithKey((String)"placeholder"));
    private static final Logger LOG = LoggerFactory.getLogger(PropertyMatcherProcessor.class);

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        if (resource instanceof ResourceLangueDecorator) {
            String content = IOUtils.toString((Reader)reader);
            Matcher matcher = PATTERN_PLACEHOLDER.matcher(content);
            StringBuffer sb = new StringBuffer();
            ResourceLangueDecorator resourceLangue = (ResourceLangueDecorator)resource;
            while (matcher.find()) {
                String variableName = matcher.group(1);
                LOG.debug("found placeholder: {}", (Object)variableName);
                matcher.appendReplacement(sb, this.replaceVariable(MessageHelper.getMessage(resourceLangue.getIdExtension(), resourceLangue.getLocale(), variableName), variableName));
            }
            matcher.appendTail(sb);
            writer.write(sb.toString());
        } else {
            writer.write(IOUtils.toString((Reader)reader));
        }
    }

    private String replaceVariable(String variableValue, String variableName) {
        String result = variableValue == null ? "" : variableValue;
        LOG.debug("replacing: [{}] with [{}]", (Object)variableName, (Object)result);
        return result;
    }
}

