/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.resources.optimizer.web;

import com.jsbsoft.jtf.core.LangueUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;

public class ResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);

    static String getMapping() {
        return "wro";
    }

    public static String computeGroupMemberUrl(ServletContext context, HttpServletRequest request, String groupName, String relativePath) throws JspException {
        String checksum = "";
        StringBuilder builder = new StringBuilder();
        builder.append(request.getContextPath());
        builder.append('/');
        builder.append(ResourceUtils.getMapping());
        builder.append('/');
        builder.append(groupName);
        builder.append('/');
        builder.append(checksum);
        builder.append(relativePath);
        return builder.toString();
    }

    private static String getCheckSum(ServletContext context, String groupName, String extension) {
        ServletContextAttributeHelper helper = new ServletContextAttributeHelper(context);
        CacheKey cacheKey = new CacheKey(groupName, ResourceType.get((String)extension.toUpperCase()), false);
        CacheValue cacheValue = (CacheValue)((WroManager)helper.getManagerFactory().create()).getCacheStrategy().get((Object)cacheKey);
        return cacheValue.getHash();
    }

    public static List<String> getResourceUrl(ServletContext context, HttpServletRequest request, HttpServletResponse response, String groupName, String type, String locale) throws JspException {
        ArrayList<String> res = new ArrayList<String>();
        WroConfiguration config = Context.get().getConfig();
        if (config.isDebug()) {
            Group group;
            ServletContextAttributeHelper helper = new ServletContextAttributeHelper(context);
            WroModelFactory model = ((WroManager)helper.getManagerFactory().create()).getModelFactory();
            WroModelInspector inspector = new WroModelInspector((WroModel)model.create());
            if (StringUtils.isNotBlank((CharSequence)locale)) {
                groupName = groupName + "_" + locale;
            }
            if ((group = inspector.getGroupByName(groupName)) != null) {
                for (Resource resource : group.getResources()) {
                    res.add(resource.getUri());
                }
            }
        } else {
            res.add(ResourceUtils.computeUrl(context, request, response, groupName, type, locale));
        }
        return res;
    }

    private static String computeUrl(ServletContext context, HttpServletRequest request, HttpServletResponse response, String groupName, String type, String locale) throws JspException {
        String extension;
        StringBuilder builder = new StringBuilder();
        if ("text/javascript".equals(type)) {
            extension = "js";
        } else if ("text/css".equals(type)) {
            extension = "css";
        } else {
            throw new JspException("type " + type + " non g\u00e9r\u00e9");
        }
        try {
            String checksum = "";
            if (StringUtils.isNotBlank((CharSequence)locale)) {
                try {
                    checksum = ResourceUtils.getCheckSum(context, groupName + "_" + locale, extension);
                    groupName = groupName + "_" + locale;
                }
                catch (WroRuntimeException e) {
                    checksum = ResourceUtils.getCheckSum(context, groupName + "_" + LangueUtil.getDefaultLocale(), extension);
                    groupName = groupName + "_" + LangueUtil.getDefaultLocale();
                }
            } else {
                checksum = ResourceUtils.getCheckSum(context, groupName, extension);
            }
            builder.append(request.getContextPath());
            builder.append('/');
            builder.append(ResourceUtils.getMapping());
            builder.append('/');
            builder.append(groupName);
            builder.append('/');
            builder.append(checksum);
            builder.append("." + extension);
        }
        catch (Exception e) {
            LOG.error("groupe " + extension + " " + groupName + " inconnu", (Throwable)e);
        }
        return builder.toString();
    }
}

