/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.security;

import com.kportal.core.config.PropertyHelper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AESHelper.class);
    private static final String ALGO_AES = "AES";
    private static final String ALGO_MD5 = "MD5";
    private static final String PROP_AES_KEY = "aes.key";

    public static String encrypt(String data, String localKey) {
        try {
            Cipher cipher = Cipher.getInstance(ALGO_AES);
            cipher.init(1, AESHelper.generateKey(localKey));
            return Base64.encodeBase64String((byte[])cipher.doFinal(data.getBytes()));
        }
        catch (Exception e) {
            LOG.error("Error while encrypting", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String data, String localKey) {
        try {
            Cipher cipher = Cipher.getInstance(ALGO_AES);
            cipher.init(2, AESHelper.generateKey(localKey));
            return new String(cipher.doFinal(Base64.decodeBase64((byte[])data.getBytes())));
        }
        catch (Exception e) {
            LOG.error("Error while decrypting AES", (Throwable)e);
            return null;
        }
    }

    private static SecretKeySpec generateKey(String key) throws NoSuchAlgorithmException {
        String sKey = (String)StringUtils.defaultIfEmpty((CharSequence)key, (CharSequence)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_AES_KEY), (CharSequence)PROP_AES_KEY));
        MessageDigest digest = MessageDigest.getInstance(ALGO_MD5);
        return new SecretKeySpec(digest.digest(sKey.getBytes()), ALGO_AES);
    }
}

