/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.core.webapp;

import com.kportal.core.config.PropertyHelper;
import com.univ.utils.ContexteUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class WebAppUtil {
    public static final String PROP_SERVER_HTML_PATH = "server.html_path";
    private static final String CONF_DIR = "conf.dir";
    private static final String SITES_PATH = "/sites/";
    private static final String WEB_INF = "/WEB-INF/";
    private static final String ADMIN_PATH = "/adminsite/";
    private static final String LIB_PATH = "/WEB-INF/lib/";
    private static final String SQL_PATH = "/WEB-INF/conf/sql/";
    private static final String CLASS_PATH = "/WEB-INF/classes/";
    private static final String PROP_EXTENSIONS_PATH = "extensions.path";
    private static final String DEFAULT_EXTENSIONS_PATH = "/extensions/";
    private static final String PROP_SAUVEGARDE_PATH = "sauvegarde.path";
    private static final String DEFAULT_SAUVEGARDE_PATH = "/WEB-INF/save";
    private static final String PROP_WORK_DEFAULTDIR = "work.defaultdir";
    private static final String DEFAULT_WORK_DEFAULTDIR = "/WEB-INF/tmp";
    private static final String PROP_UPLOAD_DEFAULTDIR = "upload.defaultdir";
    private static final String PROP_CONNECTEURS_SESSION_PATH = "connecteurs.session_path";
    private static final String DEFAULT_CONNECTEURS_SESSION_PATH = "/WEB-INF/sessions";
    private static final String PROP_XSL_PATH = "transformation.xsl_path";
    private static final String DEFAULT_XSL_PATH = "/WEB-INF/xsl";
    private static final String PROP_IMPORT_BATCH_SOURCE = "import.batch.source";
    private static final String DEFAULT_IMPORT_BATCH_SOURCE = "/WEB-INF/tmp/import";
    private static final String DEFAULT_CONF_PATH = "/WEB-INF/conf/";
    private static final String DEFAULT_FICHIERS_UAS = "/uas/";
    public static final String SG_PATH = "/servlet/com.jsbsoft.jtf.core.SG";
    public static final String CONNEXION_BO = "/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER";
    public static final String CONNEXION_FO = "/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT&ACTION=CONNECTER";

    public static String getConfDir() {
        return System.getProperty(CONF_DIR);
    }

    public static String getAbsolutePath() {
        return System.getProperty(PROP_SERVER_HTML_PATH);
    }

    public static String getWebInfPath() {
        return WebAppUtil.getAbsolutePath() + WEB_INF;
    }

    public static String getClassPath() {
        return WebAppUtil.getAbsolutePath() + CLASS_PATH;
    }

    public static String getLibPath() {
        return WebAppUtil.getAbsolutePath() + LIB_PATH;
    }

    public static String getSQLPath() {
        return WebAppUtil.getAbsolutePath() + SQL_PATH;
    }

    public static String getAbsoluteAdminsitePath() {
        return WebAppUtil.getAbsolutePath() + WebAppUtil.getRelativeAdminsitePath();
    }

    public static String getRelativeAdminsitePath() {
        return ADMIN_PATH;
    }

    public static String getRelativeExtensionsPath() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_EXTENSIONS_PATH), (CharSequence)DEFAULT_EXTENSIONS_PATH);
    }

    public static String getRelativeExtensionPath(String dossierExtension) {
        return WebAppUtil.getRelativeExtensionsPath() + dossierExtension;
    }

    public static String getAbsoluteExtensionsPath() {
        return WebAppUtil.getAbsolutePath() + WebAppUtil.getRelativeExtensionsPath();
    }

    private static boolean isExtensionExterne(String dossierExtension) {
        return new File(WebAppUtil.getAbsoluteExtensionsPath() + dossierExtension).exists();
    }

    public static String getExtensionWebInfPath(String dossierExtension) {
        if (!WebAppUtil.isExtensionExterne(dossierExtension)) {
            return WebAppUtil.getWebInfPath();
        }
        return WebAppUtil.getAbsoluteExtensionsPath() + dossierExtension + WEB_INF;
    }

    public static String getExtensionClassPath(String dossierExtension) {
        if (!WebAppUtil.isExtensionExterne(dossierExtension)) {
            return WebAppUtil.getClassPath();
        }
        return WebAppUtil.getAbsoluteExtensionsPath() + dossierExtension + CLASS_PATH;
    }

    public static String getExtensionLibPath(String dossierExtension) {
        if (!WebAppUtil.isExtensionExterne(dossierExtension)) {
            return WebAppUtil.getLibPath();
        }
        return WebAppUtil.getAbsoluteExtensionsPath() + dossierExtension + LIB_PATH;
    }

    public static String getExtensionSQLPath(String dossierExtension) {
        if (!WebAppUtil.isExtensionExterne(dossierExtension)) {
            return WebAppUtil.getSQLPath();
        }
        return WebAppUtil.getAbsoluteExtensionsPath() + dossierExtension + SQL_PATH;
    }

    public static String getUploadDefaultPath() {
        String res = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_UPLOAD_DEFAULTDIR), (CharSequence)(WebAppUtil.getAbsolutePath() + DEFAULT_WORK_DEFAULTDIR));
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    public static String getConfigurationSitesPath() {
        String cheminFichiersConf = WebAppUtil.getConfDir();
        cheminFichiersConf = StringUtils.isNotBlank((CharSequence)cheminFichiersConf) ? cheminFichiersConf + SITES_PATH : WebAppUtil.getAbsolutePath() + DEFAULT_CONF_PATH + SITES_PATH;
        File fichierConfSite = new File(cheminFichiersConf);
        if (!fichierConfSite.exists()) {
            fichierConfSite.mkdir();
        }
        return cheminFichiersConf;
    }

    public static String getAbsoluteFichiersSitesPath() {
        String res = WebAppUtil.getConfigurationSitesPath() + WebAppUtil.getRelatifFichiersSitesPath();
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    public static String getRelatifFichiersSitesPath() {
        return DEFAULT_FICHIERS_UAS;
    }

    public static String getWorkDefaultPath() {
        String res = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_WORK_DEFAULTDIR), (CharSequence)(WebAppUtil.getAbsolutePath() + DEFAULT_WORK_DEFAULTDIR));
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    public static String getLogsPath() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty("logs.path"), (CharSequence)(WebAppUtil.getAbsolutePath() + "/WEB-INF/logs"));
    }

    public static String getSessionsPath() {
        String res = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_CONNECTEURS_SESSION_PATH), (CharSequence)(WebAppUtil.getAbsolutePath() + DEFAULT_CONNECTEURS_SESSION_PATH));
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    public static String getXslPath() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_XSL_PATH), (CharSequence)(WebAppUtil.getAbsolutePath() + DEFAULT_XSL_PATH));
    }

    public static String getSauvegardePath() {
        String res = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_SAUVEGARDE_PATH), (CharSequence)(WebAppUtil.getAbsolutePath() + DEFAULT_SAUVEGARDE_PATH));
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    public static String getImportSourcePath() {
        String res = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(PROP_IMPORT_BATCH_SOURCE), (CharSequence)(WebAppUtil.getAbsolutePath() + DEFAULT_IMPORT_BATCH_SOURCE));
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    public static String getDownloadPrivatePath() {
        String res;
        String idSession = "";
        if (ContexteUtil.getContexteUniv() != null) {
            idSession = ContexteUtil.getContexteUniv().getKsession();
        }
        if (StringUtils.isNotEmpty((CharSequence)(res = WebAppUtil.getWorkDefaultPath() + (StringUtils.isNotEmpty((CharSequence)idSession) ? File.separator + idSession : ""))) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }
}

