/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class ClassLoaderHelper {
    public static void addRessource(File classFile, String extension, List<URL> ressources) throws MalformedURLException {
        for (File file : classFile.listFiles()) {
            if (file.isDirectory()) {
                ClassLoaderHelper.addRessource(file, extension, ressources);
                continue;
            }
            if (!file.getName().toLowerCase().endsWith("." + extension)) continue;
            ressources.add(file.toURI().toURL());
        }
    }

    public static void addURLToClassLoader(URLClassLoader urlClassLoader, URL url) throws IOException {
        Class<URLClassLoader> classLoaderClass = URLClassLoader.class;
        try {
            Method method = classLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, url);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Impossible d'ajouter l'URL " + url.getPath() + " au ClassLoader  ", e);
        }
    }
}

