/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension;

import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.ClassLoaderHelper;
import com.kportal.extension.IExtension;
import com.kportal.extension.exception.NoSuchBeanException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ExtensionConfigurer
extends Observable {
    public static final String EXT_CTX_FILE = "ExtensionContext.xml";
    public static final String APP_CTX_FILE = "ApplicationContext.xml";
    public static final String ADMIN_PATH = "/adminsite/";
    public static final String SAVE_PATH = "/extensions/";
    protected static final String ID_BEAN = "extensionConfigurer";
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionConfigurer.class);
    public Map<String, List<URL>> extensionNames;

    public synchronized void refresh() {
        File repWEBINF;
        this.extensionNames = new LinkedHashMap<String, List<URL>>();
        String cheminDossierDesExtension = WebAppUtil.getAbsoluteExtensionsPath();
        if (StringUtils.isNotEmpty((CharSequence)cheminDossierDesExtension)) {
            File repExtensions = new File(cheminDossierDesExtension);
            if (repExtensions.exists() && repExtensions.isDirectory()) {
                for (File rep : repExtensions.listFiles()) {
                    if (!rep.isDirectory()) continue;
                    String extensionName = rep.getName();
                    String pathConfig = WebAppUtil.getExtensionWebInfPath(extensionName) + EXT_CTX_FILE;
                    if (new File(pathConfig).exists()) {
                        if (!this.extensionNames.containsKey(extensionName)) {
                            this.extensionNames.put(extensionName, null);
                            continue;
                        }
                        LOG.warn("L'extension " + extensionName + " est d\u00e9j\u00e0 d\u00e9clar\u00e9e");
                        continue;
                    }
                    LOG.warn("Le fichier de configuration ExtensionContext.xml de l'extension " + extensionName + " n'existe pas!");
                }
            } else {
                LOG.warn("Le r\u00e9pertoire de d\u00e9ploiement des modules applicatifs : " + cheminDossierDesExtension + " n'existe pas");
            }
        } else {
            LOG.warn("Le r\u00e9pertoire de d\u00e9ploiement des modules applicatifs n'est pas renseign\u00e9");
        }
        String cheminWebInfApplicatif = WebAppUtil.getWebInfPath();
        if (StringUtils.isNotEmpty((CharSequence)cheminWebInfApplicatif) && (repWEBINF = new File(cheminWebInfApplicatif)).exists() && repWEBINF.isDirectory()) {
            for (File rep : repWEBINF.listFiles()) {
                if (!rep.isFile() || !rep.getName().endsWith(EXT_CTX_FILE)) continue;
                String extensionName = StringUtils.substringBefore((String)rep.getName(), (String)EXT_CTX_FILE);
                this.extensionNames.put(extensionName, null);
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Map<String, ApplicationContext> initAllApplicationContext(ApplicationContext contexteParent) {
        this.updateClassLoader();
        return this.updateApplicationContext(contexteParent);
    }

    private void updateClassLoader() {
        for (String extensionName : this.extensionNames.keySet()) {
            ArrayList<URL> lstUrlModule = new ArrayList<URL>();
            try {
                if (this.isConfExterne(extensionName)) {
                    File libFile;
                    File classFile = new File(WebAppUtil.getExtensionClassPath(extensionName));
                    if (classFile.exists() && classFile.isDirectory()) {
                        lstUrlModule.add(classFile.toURI().toURL());
                        ClassLoaderHelper.addRessource(classFile, "class", lstUrlModule);
                    }
                    if ((libFile = new File(WebAppUtil.getExtensionLibPath(extensionName))).exists() && libFile.isDirectory()) {
                        ClassLoaderHelper.addRessource(libFile, "jar", lstUrlModule);
                    }
                    URLClassLoader currentClassLoader = (URLClassLoader)this.getClass().getClassLoader();
                    for (URL url : lstUrlModule) {
                        ClassLoaderHelper.addURLToClassLoader(currentClassLoader, url);
                    }
                }
                this.extensionNames.put(extensionName, lstUrlModule);
            }
            catch (FileNotFoundException e) {
                LOG.error("unable to find any configuration file for the given extension", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("unable to add url to the classLoader", (Throwable)e);
            }
        }
    }

    private boolean isConfExterne(String extensionName) throws FileNotFoundException {
        File extCtx = this.getExtensionContextFile(extensionName);
        return !extCtx.getPath().startsWith(WebAppUtil.getWebInfPath());
    }

    private File getExtensionContextFile(String extensionName) throws FileNotFoundException {
        File extCtxFile = new File(WebAppUtil.getWebInfPath() + extensionName + EXT_CTX_FILE);
        String cheminWebInfExtension = WebAppUtil.getExtensionWebInfPath(extensionName);
        if (!extCtxFile.exists() && !(extCtxFile = new File(cheminWebInfExtension + EXT_CTX_FILE)).exists()) {
            throw new FileNotFoundException("Le fichier de configuration ExtensionContext.xml de l'extension " + extensionName + " n'existe pas!");
        }
        return extCtxFile;
    }

    private Map<String, ApplicationContext> updateApplicationContext(ApplicationContext contexteParent) {
        HashMap<String, ApplicationContext> extensionsCtx = new HashMap<String, ApplicationContext>();
        ArrayList<String> extensionsToRemove = new ArrayList<String>();
        for (String idExtension : this.extensionNames.keySet()) {
            try {
                File extCtxFile = this.getExtensionContextFile(idExtension);
                ClassPathXmlApplicationContext moduleCtx = new ClassPathXmlApplicationContext(new String[]{"file:" + extCtxFile.getAbsolutePath()}, contexteParent);
                if (moduleCtx.containsBean(idExtension)) {
                    if (!(moduleCtx.getBean(idExtension) instanceof IExtension)) {
                        throw new NoSuchBeanException("Le bean " + idExtension + " du fichier " + extCtxFile.getName() + " (ne contient aucun bean de type Extension du m\u00eame nom");
                    }
                } else {
                    throw new NoSuchBeanException("Le fichier de configuration " + extCtxFile.getName() + " de l'extension " + idExtension + " ne contient aucun bean de type Extension du m\u00eame nom");
                }
                extensionsCtx.put(idExtension, (ApplicationContext)moduleCtx);
            }
            catch (NoSuchBeanException | FileNotFoundException | BeansException e) {
                LOG.error("Erreur dans le chargement de l'extension " + idExtension, e);
                extensionsToRemove.add(idExtension);
            }
        }
        for (String idExtension : extensionsToRemove) {
            this.extensionNames.remove(idExtension);
        }
        return extensionsCtx;
    }
}

