/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.CoreExtension;
import com.kportal.extension.ExtensionConfigurer;
import com.kportal.extension.ExtensionManager;
import com.kportal.extension.IExtension;
import com.kportal.extension.Version;
import com.univ.multisites.Site;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ExtensionHelper {
    public static final String EXTENSION_TEMPLATE = ".jsp";
    public static final String PATH_JSP = "/jsp";
    public static final String PATH_WEB_INF_JSP = "/WEB-INF/jsp";
    public static final String PATH_FO = "/fo";

    public static ExtensionConfigurer getExtensionConfigurer() {
        return (ExtensionConfigurer)ApplicationContextManager.getCoreContextBean("extensionConfigurer");
    }

    public static ExtensionManager getExtensionManager() {
        return (ExtensionManager)ApplicationContextManager.getCoreContextBean("extensionManager");
    }

    public static IExtension getExtension(String id) {
        return ExtensionHelper.getExtensionManager().getExtension(id);
    }

    public static String getMessage(String id, String key) {
        String message;
        if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)(message = MessageHelper.getMessage(id, key)))) {
            return message;
        }
        return key;
    }

    public static CoreExtension getCoreExtension() {
        return (CoreExtension)ExtensionHelper.getExtension("core");
    }

    public static boolean checkCoreVersion(String coreVersion) {
        boolean versionCompatible = Boolean.TRUE;
        Version v = new Version(coreVersion);
        Version core = new Version(ExtensionHelper.getCoreExtension().getVersion());
        if (v.isValid() && !core.equalsMineur(v)) {
            versionCompatible = Boolean.FALSE;
        }
        return versionCompatible;
    }

    public static String getTemplateExtension(String idExtension, String pathRelatif, boolean front) {
        if (!pathRelatif.endsWith(EXTENSION_TEMPLATE)) {
            pathRelatif = pathRelatif + EXTENSION_TEMPLATE;
        }
        if (!pathRelatif.startsWith("/")) {
            pathRelatif = "/" + pathRelatif;
        }
        String path = pathRelatif;
        if (front) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            String dossierJspFo = "";
            if (ctx != null && ctx.getInfosSite() != null) {
                dossierJspFo = ctx.getInfosSite().getJspFo();
            }
            if (StringUtils.isEmpty((CharSequence)dossierJspFo)) {
                dossierJspFo = Site.getSitePrincipal().getJspFo();
            }
            if (path.startsWith("/WEB-INF/jsp/") && path.contains("/fo/")) {
                path = StringUtils.replace((String)path, (String)"/fo/", (String)"/");
                path = StringUtils.replace((String)path, (String)"/WEB-INF/jsp/", (String)(WebAppUtil.getRelativeExtensionPath((String)StringUtils.defaultIfEmpty((CharSequence)idExtension, (CharSequence)"core")) + "/"));
                path = dossierJspFo + path;
            } else if (path.startsWith("/jsp/") && !dossierJspFo.equals(PATH_JSP)) {
                path = StringUtils.replace((String)path, (String)PATH_JSP, (String)dossierJspFo);
            }
        } else if (path.startsWith("/WEB-INF/jsp/")) {
            path = StringUtils.replace((String)path, (String)"/WEB-INF/jsp/", (String)(PATH_WEB_INF_JSP + WebAppUtil.getRelativeExtensionPath((String)StringUtils.defaultIfEmpty((CharSequence)idExtension, (CharSequence)"core")) + "/"));
        }
        if (new File(WebAppUtil.getAbsolutePath() + path).exists()) {
            return path;
        }
        if (StringUtils.isNotEmpty((CharSequence)idExtension) && ExtensionHelper.getExtension(idExtension) != null) {
            path = ExtensionHelper.getExtension(idExtension).getRelativePath() + pathRelatif;
            if (new File(WebAppUtil.getAbsolutePath() + path).exists()) {
                return path;
            }
        }
        if (new File(WebAppUtil.getAbsolutePath() + pathRelatif).exists()) {
            return pathRelatif;
        }
        return "";
    }

    public static String getTemplateExtension(String idExtension, String pathRelatif) {
        return ExtensionHelper.getTemplateExtension(idExtension, pathRelatif, Boolean.TRUE);
    }
}

