/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.MySQLDumpWriter;
import com.jsbsoft.jtf.database.MySQLScriptLoader;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.ExtensionConfigurer;
import com.kportal.extension.IExtension;
import com.kportal.extension.IExtensionConfig;
import com.kportal.extension.Version;
import com.kportal.extension.om.Extension;
import com.kportal.util.compress.Zip;
import com.univ.utils.ContexteDao;
import com.univ.utils.FileUtil;
import fr.kosmos.cluster.api.Cluster;
import fr.kosmos.cluster.api.MessageHandler;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ExtensionManager
extends Observable
implements Observer,
MessageHandler<Serializable> {
    private static final String POINT_SQL = ".sql";
    private static final String _DATA = "_data";
    protected static final String ID_BEAN = "extensionManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionManager.class);
    public ExtensionConfigurer extensionConfigurer;
    private Cluster cluster;
    private HashMap<String, IExtension> extensions = new HashMap();
    private Version core;

    public void init() {
        this.extensionConfigurer.addObserver(this);
        if (this.cluster != null) {
            this.cluster.registerService((MessageHandler)this);
        }
    }

    public synchronized void refresh() {
        this.extensions = new HashMap();
        this.loadExtension("core");
        if (this.extensions.get("core") == null) {
            throw new RuntimeException("Impossible de d\u00e9marrer l'application sans extension core");
        }
        for (String idAppCtx : ApplicationContextManager.getAllApplicationContext().keySet()) {
            if (idAppCtx.equals("core")) continue;
            this.loadExtension(idAppCtx);
        }
        this.cleanDB();
        this.setChanged();
        this.notifyObservers();
        LOGGER.info("Chargement des extensions OK");
    }

    private void loadExtension(String idAppCtx) {
        ApplicationContext appCtx = ApplicationContextManager.getAllApplicationContext().get(idAppCtx);
        Map exts = appCtx.getBeansOfType(IExtension.class);
        for (String name : exts.keySet()) {
            if (!name.equals(idAppCtx)) continue;
            IExtension extension = (IExtension)exts.get(name);
            extension.setId(name);
            extension.setExterne(this.isExterne(name));
            if (extension.isExterne()) {
                extension.setRelativePath(WebAppUtil.getRelativeExtensionPath(name));
            } else {
                extension.setType(0);
            }
            try {
                this.initExtension(extension);
                if (!this.isCore(extension) && extension.getEtat() != 1) continue;
                this.extensions.put(name, extension);
            }
            catch (Exception e) {
                LOGGER.error("Erreur de chargement de l'extension id=" + extension.getId() + " : " + e.getMessage());
            }
        }
    }

    private boolean checkVersion(IExtension extension) {
        boolean versionCompatible = Boolean.TRUE;
        Version v = new Version(extension.getCoreVersion());
        if (v.isValid()) {
            if (this.core.equalsMineur(v)) {
                if (this.core.greaterMaintenance(v)) {
                    LOGGER.warn("Une version plus r\u00e9cente de l'extension " + extension.getId() + " est disponible");
                }
            } else {
                LOGGER.error("La version de l'extension " + extension.getId() + " n'est plus compatible avec celle du socle, l'extension a \u00e9t\u00e9 automatiquement d\u00e9sactiv\u00e9e");
                versionCompatible = Boolean.FALSE;
            }
        } else {
            LOGGER.warn("Impossible de valider la compatibilit\u00e9 de la version de l'extension " + extension.getId());
        }
        return versionCompatible;
    }

    private boolean isExterne(String name) {
        File repExtension = new File(WebAppUtil.getAbsoluteExtensionsPath() + name);
        return repExtension.exists();
    }

    private boolean isCore(IExtension extension) {
        return extension.getId().equals("core");
    }

    private void cleanDB() {
        Extension extensionDB = new Extension();
        try (ContexteDao ctx = new ContexteDao();){
            extensionDB.setCtx(ctx);
            extensionDB.select("");
            while (extensionDB.nextItem()) {
                if (extensionDB.getExtension() != null) continue;
                this.removeModule(extensionDB);
                extensionDB.delete();
            }
        }
        catch (Exception e) {
            LOGGER.error("Erreur de nettoyage de la table EXTENSION", (Throwable)e);
        }
    }

    private void initExtension(IExtension extension) throws Exception {
        Extension extensionDB = new Extension();
        try (ContexteDao ctx = new ContexteDao();){
            try {
                extensionDB.setCtx(ctx);
                extensionDB.setIdExtension(Long.valueOf(extension.getId().hashCode()));
                extensionDB.retrieve();
            }
            catch (Exception e) {
                extensionDB.setTables(this.loadSQL(extension, "", ""));
                extensionDB.setEtat(extension.getEtat());
                extensionDB.setType(extension.getType());
                extensionDB.setIdBean(extension.getId());
                extensionDB.setLibelle(StringUtils.isNotEmpty((CharSequence)extension.getLibelle()) ? extension.getLibelle() : extension.getId());
                extensionDB.setVersion(extension.getVersion());
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTimeInMillis(System.currentTimeMillis());
                if (this.isCore(extension)) {
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                }
                extensionDB.setDateCreation(new Date(calendar.getTimeInMillis()));
                extensionDB.setDateModification(new Date(calendar.getTimeInMillis()));
                extensionDB.add();
            }
            String oldVersion = extensionDB.getVersion();
            boolean versionCompatible = Boolean.TRUE;
            if (this.isCore(extension)) {
                this.core = new Version(extension.getVersion());
            } else {
                versionCompatible = this.checkVersion(extension);
            }
            if (!versionCompatible || extensionDB.getEtat().intValue() != extension.getEtat() || extensionDB.getType().intValue() != extension.getType() || !extensionDB.getVersion().equals(extension.getVersion())) {
                if (extensionDB.getEtat() == -2) {
                    extensionDB.setEtat(extension.getEtat());
                    extensionDB.setIdBean(extension.getId());
                    extensionDB.setLibelle(StringUtils.isNotEmpty((CharSequence)extension.getLibelle()) ? extension.getLibelle() : extension.getId());
                }
                if (versionCompatible) {
                    if (!extensionDB.getVersion().equals(extension.getVersion()) || extensionDB.getEtat() == -1) {
                        extensionDB.setTables(this.loadSQL(extension, extensionDB.getTables(), extensionDB.getVersion()));
                        extensionDB.setVersion(extension.getVersion());
                        if (extensionDB.getEtat() == -1) {
                            extensionDB.setEtat(extension.getEtat());
                        }
                    }
                    if (extensionDB.getType().intValue() != extension.getType()) {
                        extensionDB.setType(extension.getType());
                    }
                } else {
                    extensionDB.setEtat(-1);
                }
                extensionDB.setDateModification(new Date(System.currentTimeMillis()));
                extensionDB.update();
            }
            extension.setEtat(extensionDB.getEtat());
            if (extension.getEtat() != -1) {
                for (IExtensionConfig config : ApplicationContextManager.getBeansOfType(extension.getId(), IExtensionConfig.class).values()) {
                    config.init(extension, new Version(oldVersion));
                }
            }
        }
    }

    private String loadSQL(IExtension extension, String tablesExistantes, String versionCourante) throws Exception {
        HashSet<String> lTables;
        block47: {
            lTables = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)tablesExistantes)) {
                lTables.addAll(Arrays.asList(tablesExistantes.split(";")));
            }
            File sqlFile = null;
            boolean doOnlyCreateTable = false;
            ContexteDao ctx = new ContexteDao();
            Object object = null;
            try {
                Throwable throwable;
                FileReader fileReader;
                MySQLScriptLoader scriptLoader = new MySQLScriptLoader(ctx.getConnection());
                if (StringUtils.isBlank((CharSequence)versionCourante)) {
                    doOnlyCreateTable = true;
                    sqlFile = new File(WebAppUtil.getExtensionSQLPath(extension.getId()) + extension.getId() + POINT_SQL);
                } else {
                    sqlFile = new File(WebAppUtil.getExtensionSQLPath(extension.getId()) + extension.getId() + "_" + versionCourante + "_" + extension.getVersion() + POINT_SQL);
                }
                if (sqlFile.exists()) {
                    try {
                        fileReader = new FileReader(sqlFile);
                        throwable = null;
                        try {
                            scriptLoader.setStopOnError(true);
                            scriptLoader.setDoOnlyCreateTable(doOnlyCreateTable);
                            scriptLoader.runScript(fileReader);
                            lTables.addAll(scriptLoader.getCreatedTables());
                            lTables.addAll(scriptLoader.getExistingTables());
                            LOGGER.info("Chargement du fichier " + sqlFile.getName() + " OK");
                            if (scriptLoader.getCreatedTables().size() > 0) {
                                LOGGER.info("Table(s) cr\u00e9\u00e9e(s) : " + scriptLoader.getCreatedTables().toString());
                            }
                            if (scriptLoader.getExistingTables().size() > 0) {
                                LOGGER.info("Table(s) existante(s) : " + scriptLoader.getExistingTables().toString());
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fileReader != null) {
                                if (throwable != null) {
                                    try {
                                        fileReader.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    fileReader.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Erreur de chargement du fichier " + sqlFile.getName(), e);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)versionCourante) || !scriptLoader.getExistingTables().isEmpty() || !(sqlFile = new File(WebAppUtil.getExtensionSQLPath(extension.getId()) + extension.getId() + _DATA + POINT_SQL)).exists()) break block47;
                fileReader = new FileReader(sqlFile);
                throwable = null;
                try {
                    scriptLoader.setStopOnError(false);
                    scriptLoader.setDoOnlyCreateTable(false);
                    scriptLoader.runScript(fileReader);
                    LOGGER.info("Chargement du fichier " + sqlFile.getName() + " OK");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileReader != null) {
                        if (throwable != null) {
                            try {
                                fileReader.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            fileReader.close();
                        }
                    }
                }
            }
            catch (Throwable scriptLoader) {
                object = scriptLoader;
                throw scriptLoader;
            }
            finally {
                if (ctx != null) {
                    if (object != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable scriptLoader) {
                            ((Throwable)object).addSuppressed(scriptLoader);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        String tables = "";
        for (String table : lTables) {
            if (tables.length() > 0) {
                tables = tables + ";";
            }
            tables = tables + table;
        }
        return tables;
    }

    public Map<String, IExtension> getExtensions() {
        return this.extensions;
    }

    public IExtension getExtension(String name) {
        return this.extensions.get(StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)"core"));
    }

    @Override
    public void update(Observable o, Object arg) {
        ApplicationContextManager.refresh(this.extensionConfigurer);
        this.refresh();
    }

    public ExtensionConfigurer getExtensionConfigurer() {
        return this.extensionConfigurer;
    }

    public void setExtensionConfigurer(ExtensionConfigurer extensionConfigurer) {
        this.extensionConfigurer = extensionConfigurer;
    }

    public void removeExtension(String idBean) throws Exception {
        Extension extensionDB;
        IExtension extension = this.extensions.get(idBean);
        if (extension == null) {
            extension = (IExtension)ApplicationContextManager.getBean(idBean, idBean);
        }
        if ((extensionDB = this.getExtensionDB(extension)).getIdBean().equals("core")) {
            throw new Exception("Impossible de supprimer l'extension core");
        }
        List<Object> tables = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)extensionDB.getTables())) {
            tables = Arrays.asList(extensionDB.getTables().split(";"));
        }
        if (tables.size() > 0) {
            String path = WebAppUtil.getExtensionSQLPath(extension.getId()) + extension.getId() + _DATA + POINT_SQL;
            this.dumpTableSQL(extension, tables, path);
        }
        for (IExtensionConfig config : ApplicationContextManager.getBeansOfType(extension.getId(), IExtensionConfig.class).values()) {
            config.clean(extension);
        }
        this.saveFolder(extension);
        if (extension.loadSQL() && tables.size() > 0) {
            this.removeTablesSQL(extension, tables);
        }
        this.removeModule(extensionDB);
        extensionDB.delete();
    }

    private void saveFolder(IExtension extension) throws Exception {
        try {
            File rep = new File(WebAppUtil.getAbsolutePath() + extension.getRelativePath());
            File archive = new File(FileUtil.mkdir(WebAppUtil.getSauvegardePath() + "/extensions/") + extension.getId());
            Zip.compress(rep, archive);
            FileDeleteStrategy.FORCE.delete(rep);
        }
        catch (Exception e) {
            throw new Exception("Impossible de sauvegarder le r\u00e9pertoire de l'extension id=" + extension.getId(), e);
        }
    }

    private void removeModule(Extension extensionDB) throws Exception {
        PreparedStatement _stmt = null;
        try (ContexteDao ctx = new ContexteDao();){
            String query = "DELETE FROM MODULE WHERE ID_EXTENSION='" + extensionDB.getIdExtension() + "'";
            _stmt = ctx.getConnection().prepareStatement(query);
            _stmt.executeUpdate();
            _stmt.close();
        }
        catch (Exception e) {
            throw new Exception("Impossible de supprimer les modules de l'extension id=" + extensionDB.getIdBean(), e);
        }
        finally {
            _stmt = null;
        }
    }

    private void removeTablesSQL(IExtension extension, List<String> tables) throws Exception {
        try (ContexteDao ctx = new ContexteDao();){
            MySQLScriptLoader scriptLoader = new MySQLScriptLoader(ctx.getConnection());
            for (String table : tables) {
                scriptLoader.executeDropTable(table);
            }
        }
        catch (Exception e) {
            throw new Exception("Impossible de supprimer les tables SQL de l'extension id=" + extension.getId(), e);
        }
    }

    private Extension getExtensionDB(IExtension extension) throws Exception {
        Extension extensionDB = new Extension();
        try (ContexteDao ctx = new ContexteDao();){
            extensionDB.setCtx(ctx);
            extensionDB.setIdExtension(Long.valueOf(extension.getId().hashCode()));
            extensionDB.retrieve();
        }
        catch (Exception e) {
            throw new Exception("Impossible de trouver l'extension id=" + extension.getId(), e);
        }
        return extensionDB;
    }

    private void dumpTableSQL(IExtension extension, List<String> tables, String path) throws Exception {
        try {
            MySQLDumpWriter dumpWriter = new MySQLDumpWriter();
            dumpWriter.setExportStructure(false);
            dumpWriter.dumpDB(tables, path);
        }
        catch (IOException e) {
            throw new Exception("Impossible de sauvegarder les tables SQL de l'extension id=" + extension.getId(), e);
        }
    }

    public void handleMessage(Serializable message) {
        this.refresh();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }
}

