/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    int numeroMajeur = 0;
    int numeroMineur = 0;
    int numeroMaintenance = 0;

    public Version(String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return;
        }
        String[] numeros = version.split("\\.");
        String numero = "";
        for (int i = 0; i < numeros.length; ++i) {
            try {
                numero = StringUtils.substringBefore((String)numeros[i], (String)"-");
                int temp = Integer.parseInt(numero);
                switch (i) {
                    case 0: {
                        this.numeroMajeur = temp;
                        break;
                    }
                    case 1: {
                        this.numeroMineur = temp;
                        break;
                    }
                    case 2: {
                        this.numeroMaintenance = temp;
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Erreur de parsing du num\u00e9ro " + numero + " de la version " + version);
            }
        }
    }

    public Version(int numeroMajeur, int numeroMineur, int numeroMaintenance) {
        this.numeroMajeur = numeroMajeur;
        this.numeroMineur = numeroMineur;
        this.numeroMaintenance = numeroMaintenance;
    }

    public boolean equalsMajeur(Version v) {
        return this.numeroMajeur == v.numeroMajeur;
    }

    public boolean equalsMineur(Version v) {
        return this.equalsMajeur(v) && this.numeroMineur == v.numeroMineur;
    }

    public boolean equalsMaintenance(Version v) {
        return this.equalsMineur(v) && this.numeroMaintenance == v.numeroMaintenance;
    }

    public boolean greaterMajeur(Version v) {
        return this.numeroMajeur > v.numeroMajeur;
    }

    public boolean greaterMineur(Version v) {
        return this.greaterMajeur(v) || this.equalsMajeur(v) && this.numeroMineur > v.numeroMineur;
    }

    public boolean greaterMaintenance(Version v) {
        return this.greaterMineur(v) || this.equalsMineur(v) && this.numeroMaintenance > v.numeroMaintenance;
    }

    public boolean equals(Version v) {
        return this.equalsMaintenance(v);
    }

    public boolean greater(Version v) {
        return this.greaterMaintenance(v);
    }

    public boolean isValid() {
        return this.numeroMajeur > 0;
    }
}

