/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cache.CacheLoaderManager;
import com.kportal.core.autorisation.Permission;
import com.kportal.core.context.BeanUtil;
import com.kportal.core.context.OverridedContextBean;
import com.kportal.extension.ExtensionManager;
import com.kportal.extension.IExtension;
import com.kportal.extension.module.IModule;
import com.kportal.extension.om.Module;
import com.univ.utils.ContexteDao;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ModuleManager
extends Observable
implements Observer {
    public static final String ID_BEAN = "moduleManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleManager.class);
    private ExtensionManager extensionManager;
    private CacheLoaderManager cacheLoaderManager;
    private Map<String, IModule> modules;

    public void init() {
        this.cacheLoaderManager.addObserver(this);
    }

    public void refresh() {
        this.modules = new HashMap<String, IModule>();
        for (IExtension extension : this.extensionManager.getExtensions().values()) {
            ApplicationContext appCtx = ApplicationContextManager.getApplicationContext(extension.getId());
            for (Object name : appCtx.getBeansOfType(IModule.class).keySet()) {
                IModule module = (IModule)appCtx.getBean((String)name);
                module.setId((String)name);
                module.setIdExtension(extension.getId());
                module.setLibelleExtension(extension.getLibelle());
                for (Permission permission : module.getPermissions()) {
                    if (StringUtils.isEmpty((CharSequence)permission.getId())) {
                        permission.setId(module.getId());
                    }
                    permission.setIdModule(module.getId());
                    permission.setIdExtension(module.getIdExtension());
                }
                try {
                    this.loadModuleDB(module);
                    this.modules.put(BeanUtil.getBeanKey((String)name, extension.getId()), module);
                }
                catch (Exception e) {
                    LOGGER.warn("Erreur de chargement du module id=" + module.getId() + ", extension=" + extension.getId() + " : " + e.getMessage());
                }
            }
        }
        this.cleanDB();
        this.loadModules();
        this.setChanged();
        this.notifyObservers();
        LOGGER.info("Chargement des modules OK");
    }

    private void loadModules() {
        ArrayList<String> aDecharger = new ArrayList<String>();
        ArrayList<String> aDesactiver = new ArrayList<String>();
        for (IModule iModule : this.modules.values()) {
            if (iModule.getEtat() == 1) {
                String idBeanOver;
                if (!(iModule instanceof OverridedContextBean) || this.modules.get(idBeanOver = BeanUtil.getBeanKey(((OverridedContextBean)((Object)iModule)).getIdBeanToOverride(), ((OverridedContextBean)((Object)iModule)).getIdExtensionToOverride())) == null) continue;
                aDecharger.add(idBeanOver);
                continue;
            }
            aDesactiver.add(BeanUtil.getBeanKey(iModule.getId(), iModule.getIdExtension()));
        }
        Throwable throwable = null;
        try (ContexteDao ctx = new ContexteDao();){
            for (String key : aDecharger) {
                Module moduleDB = new Module();
                try {
                    moduleDB.setCtx(ctx);
                    moduleDB.setIdModule(Long.valueOf(key.hashCode()));
                    moduleDB.retrieve();
                    moduleDB.setEtat(1);
                    moduleDB.setType(0);
                    moduleDB.update();
                }
                catch (Exception e) {
                    LOGGER.error("erreur lors des requetes SQL sur la table module", (Throwable)e);
                }
                this.modules.remove(key);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (String string : aDesactiver) {
            this.modules.remove(string);
        }
    }

    private void cleanDB() {
        Module moduleDB = new Module();
        try (ContexteDao ctx = new ContexteDao();){
            moduleDB.setCtx(ctx);
            moduleDB.select("", null, "", null, null, -2, null, "");
            while (moduleDB.nextItem()) {
                moduleDB.delete();
            }
        }
        catch (Exception e) {
            LOGGER.error("Erreur de nettoyage de la table MODULE", (Throwable)e);
        }
    }

    private void loadModuleDB(IModule module) throws Exception {
        Module moduleDB = new Module();
        try (ContexteDao ctx = new ContexteDao();){
            moduleDB.setIdModule(Long.valueOf(BeanUtil.getBeanKey(module.getId(), module.getIdExtension()).hashCode()));
            moduleDB.setCtx(ctx);
            try {
                moduleDB.retrieve();
            }
            catch (Exception e) {
                this.setModuleDB(module, moduleDB);
                moduleDB.setDateCreation(new Date(System.currentTimeMillis()));
                moduleDB.add();
            }
            if (moduleDB.getEtat() == -2 || moduleDB.getType().intValue() != module.getType()) {
                if (moduleDB.getEtat() == -2) {
                    this.setModuleDB(module, moduleDB);
                }
                moduleDB.setType(module.getType());
                moduleDB.update();
            }
        }
        module.setEtat(moduleDB.getEtat());
        module.setLibelle(moduleDB.getLibelle());
    }

    private void setModuleDB(IModule module, Module moduleDB) {
        moduleDB.setEtat(module.getEtat());
        moduleDB.setType(module.getType());
        moduleDB.setIdBean(module.getId());
        moduleDB.setLibelle(StringUtils.isNotEmpty((CharSequence)module.getLibelle()) ? module.getLibelle() : module.getId());
        moduleDB.setIdExtension(Long.valueOf(module.getIdExtension().hashCode()));
        moduleDB.setDateModification(new Date(System.currentTimeMillis()));
    }

    public <T extends IModule> Collection<T> getModules(Class<T> type) {
        ArrayList<IModule> res = new ArrayList<IModule>();
        for (IModule module : this.modules.values()) {
            if (!type.isAssignableFrom(module.getClass())) continue;
            res.add(module);
        }
        return res;
    }

    public Map<String, IModule> getModules() {
        return this.modules;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setCacheLoaderManager(CacheLoaderManager cacheLoaderManager) {
        this.cacheLoaderManager = cacheLoaderManager;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refresh();
    }
}

