/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.composant;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.extension.module.DefaultModuleImpl;
import com.kportal.extension.module.composant.ActionComposant;
import com.kportal.extension.module.composant.IComposant;
import com.kportal.extension.module.composant.Menu;
import com.kportal.extension.module.composant.ServletComposant;
import com.univ.objetspartages.om.AutorisationBean;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Composant
extends DefaultModuleImpl
implements IComposant,
Comparable<Composant> {
    public static final Logger LOG = LoggerFactory.getLogger(Composant.class);
    public String idMenuBoParent;
    public String urlAccueilBo;
    public ActionComposant actionDefaut;
    public Integer ordre = 10000;
    public String parametreProcessus = "";
    public boolean accessibleBO = Boolean.TRUE;
    public List<ActionComposant> actions = new ArrayList<ActionComposant>();

    @Override
    public String getIdMenuBoParent() {
        return this.idMenuBoParent;
    }

    public void setIdMenuBoParent(String idMenuParent) {
        this.idMenuBoParent = idMenuParent;
    }

    public ActionComposant getActionDefaut() {
        return this.actionDefaut;
    }

    public void setActionDefaut(ActionComposant actionDefaut) {
        this.actionDefaut = actionDefaut;
    }

    public void setUrlAccueilBo(String urlAccueilBo) {
        this.urlAccueilBo = urlAccueilBo;
    }

    @Override
    public int getOrdre() {
        return this.ordre;
    }

    public void setOrdre(int ordre) {
        this.ordre = ordre;
    }

    public boolean isAccessibleBO() {
        return this.accessibleBO;
    }

    public void setAccessibleBO(boolean isAccessibleBO) {
        this.accessibleBO = isAccessibleBO;
    }

    @Override
    public boolean isVisible(AutorisationBean autorisation) {
        return this.accessibleBO && autorisation != null;
    }

    @Override
    public String getParametreProcessus() {
        return this.parametreProcessus;
    }

    public void setParametreProcessus(String parametreProcessus) {
        this.parametreProcessus = parametreProcessus;
    }

    @Override
    public int compareTo(Composant composant) {
        return this.ordre.compareTo(composant.ordre) != 0 ? this.ordre.compareTo(composant.ordre) : this.getLibelleAffichable().compareTo(composant.getLibelleAffichable());
    }

    @Override
    public List<ActionComposant> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionComposant> actions) {
        this.actions = actions;
    }

    @Override
    public boolean isActionVisible(AutorisationBean autorisation, String code) {
        return this.accessibleBO && autorisation != null;
    }

    @Override
    public Menu getMenuAccueil(AutorisationBean autorisation) {
        if (autorisation != null) {
            Menu menuAccueil = new Menu();
            menuAccueil.setUrl(this.getUrlParAction(this.actionDefaut));
            menuAccueil.setLibelle(this.getLibelleAffichable());
            menuAccueil.setVisuel(this.actionDefaut.getCode().toLowerCase() + " " + this.getId());
            return menuAccueil;
        }
        return null;
    }

    @Override
    public Menu getMenuGeneral(AutorisationBean autorisation, InfoBean infoBean) {
        if (autorisation != null) {
            Menu menuActions = new Menu();
            for (ActionComposant action : this.actions) {
                if (!this.isActionVisible(autorisation, action.getCode())) continue;
                Menu menuActionCourante = new Menu();
                menuActionCourante.setCode(action.getCode());
                menuActionCourante.setLibelle(this.calculerLibelle(infoBean, action));
                menuActionCourante.setUrl(this.getUrlParAction(action));
                menuActionCourante.setVisuel(action.getCode().toLowerCase() + " " + this.getId());
                menuActions.addSousMenu(menuActionCourante);
            }
            return menuActions;
        }
        return null;
    }

    @Override
    public String getUrlAccueilBo() {
        if (StringUtils.isNotBlank((CharSequence)this.urlAccueilBo)) {
            return this.urlAccueilBo;
        }
        if (this.actionDefaut != null) {
            return this.getUrlParAction(this.actionDefaut);
        }
        return "";
    }

    private String getUrlParAction(ActionComposant action) {
        StringBuilder urlAConstruire = new StringBuilder();
        if (action instanceof ServletComposant) {
            ServletComposant servletComposant = (ServletComposant)action;
            try {
                String[] urls;
                Class<?> clazz = Class.forName(servletComposant.getServlet());
                if (clazz.isAnnotationPresent(WebServlet.class) && (urls = clazz.getAnnotation(WebServlet.class).urlPatterns()).length == 1) {
                    urlAConstruire.append(urls[0]);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error("Servlet d'action " + servletComposant.getServlet() + " inconnue", (Throwable)e);
            }
        } else {
            urlAConstruire.append("/servlet/com.jsbsoft.jtf.core.SG?EXT=");
            urlAConstruire.append(this.getIdExtension()).append("&PROC=").append(this.getParametreProcessus()).append("&ACTION=");
            if (action != null) {
                urlAConstruire.append(action.getCode());
            } else {
                urlAConstruire.append("ACCUEIL");
            }
        }
        return urlAConstruire.toString();
    }

    private String calculerLibelle(InfoBean infoBean, ActionComposant action) {
        StringBuilder codeLibelle = new StringBuilder();
        String key = "";
        key = StringUtils.isNotEmpty((CharSequence)infoBean.getNomProcessus()) ? infoBean.getNomProcessus() : this.getId();
        if (StringUtils.isNotBlank((CharSequence)action.getCode())) {
            codeLibelle.append(".").append(action.getCode());
        }
        codeLibelle.insert(0, key);
        String libelle = this.getMessage(codeLibelle.toString());
        if (StringUtils.isBlank((CharSequence)libelle)) {
            codeLibelle.replace(0, key.length(), "DEFAUT");
            libelle = this.getMessage(codeLibelle.toString());
        }
        return libelle;
    }

    @Override
    public String getLibelleMenu() {
        return this.getLibelleAffichable();
    }
}

