/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.composant;

import com.kportal.core.autorisation.util.PermissionUtil;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.composant.ComposantAdministration;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.PermissionBean;
import java.util.Arrays;
import java.util.Collection;

public class ComposantUtilisateur
extends ComposantAdministration {
    public static final String ID_BEAN = "composantUtilisateur";
    public static final String CODE_ACTION_CONSULTATION = "C";
    public static final String CODE_PERMISSION = "user";
    public static final String CODE_ACTION_GESTION = "G";
    public static final Collection<String> ECRANS_LOGIQUES_CONSULTATION = Arrays.asList("RECHERCHE", "LISTE");
    public static final Collection<String> ACTIONS_CONSULTATION = Arrays.asList("LISTE", "ACCUEIL", "RECHERCHE", "RECHERCHER");

    @Override
    public boolean isVisible(AutorisationBean autorisation) {
        boolean isVisible = Boolean.FALSE;
        if (this.isAccessibleBO() && autorisation != null) {
            isVisible = autorisation.possedePermission(ComposantUtilisateur.getPermissionGestion());
        }
        return isVisible;
    }

    @Override
    public boolean isActionVisible(AutorisationBean autorisation, String code) {
        return this.isVisible(autorisation);
    }

    public static IModule getModule() {
        return ModuleHelper.getModule("core", ID_BEAN);
    }

    public static PermissionBean getPermissionGestion() {
        return PermissionUtil.getPermissionBean(ComposantUtilisateur.getModule(), CODE_PERMISSION, CODE_ACTION_GESTION);
    }

    public static PermissionBean getPermissionConsultation() {
        return PermissionUtil.getPermissionBean(ComposantUtilisateur.getModule(), CODE_PERMISSION, CODE_ACTION_CONSULTATION);
    }

    public static boolean isAutoriseParActionProcessusEtEcranLogique(AutorisationBean autorisations, String action, String ecranLogique) {
        boolean isAutorise;
        boolean bl = isAutorise = autorisations != null && autorisations.isWebMaster();
        if (!isAutorise && autorisations != null) {
            isAutorise = ACTIONS_CONSULTATION.contains(action) || ECRANS_LOGIQUES_CONSULTATION.contains(ecranLogique) ? autorisations.possedePermission(ComposantUtilisateur.getPermissionConsultation()) : autorisations.possedePermission(ComposantUtilisateur.getPermissionGestion());
        }
        return isAutorise;
    }
}

