/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.objetspartages;

import com.kportal.core.context.BeanUtil;
import com.kportal.extension.module.DefaultModuleImpl;
import com.kportal.extension.module.plugin.objetspartages.IPluginFiche;
import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUtil;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultPluginFiche
extends DefaultModuleImpl
implements IPluginFiche {
    private String pathSaisieBo = "";
    private String pathSaisieFo = "";
    private String pathTemplateFo = "";
    private List<String> classes;
    private List<String> objets;

    @Override
    public List<String> getObjets() {
        return this.objets;
    }

    public void setObjets(List<String> objets) {
        this.objets = objets;
    }

    @Override
    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    @Override
    public String getPathSaisieBo() {
        return this.pathSaisieBo;
    }

    public void setPathSaisieBo(String pathSaisieB0) {
        this.pathSaisieBo = pathSaisieB0;
    }

    @Override
    public String getPathSaisieFo() {
        return this.pathSaisieFo;
    }

    public void setPathSaisieFo(String pathSaisieF0) {
        this.pathSaisieFo = pathSaisieF0;
    }

    @Override
    public boolean isActive(String classe) {
        if (this.classes == null) {
            return Boolean.TRUE;
        }
        if (this.classes.contains(classe)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean hasObjet(String classe) {
        if (StringUtils.isEmpty((CharSequence)classe)) {
            return Boolean.TRUE;
        }
        if (this.objets != null && this.objets.contains(classe)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void postTraiterPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
    }

    @Override
    public void preparerPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
    }

    @Override
    public void traiterPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
    }

    @Override
    public void preTraiterPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
    }

    @Override
    public void supprimerObjets(FicheUniv ficheUniv, Metatag meta, String classeObjetCible) throws Exception {
        for (String classeObjet : this.getListeObjets(classeObjetCible)) {
            Object objet = Class.forName(classeObjet).newInstance();
            if (!(objet instanceof ObjetPluginContenu)) continue;
            ObjetPluginContenu sousObjet = (ObjetPluginContenu)objet;
            ContexteDao ctx = new ContexteDao();
            Throwable throwable = null;
            try {
                sousObjet.setCtx(ctx);
                ClauseWhere where = new ClauseWhere(ConditionHelper.egal("ID_META", meta.getIdMetatag(), TypeOperande.LONG));
                sousObjet.select(where.formaterSQL());
                while (sousObjet.nextItem()) {
                    sousObjet.delete();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
    }

    @Override
    public List<ObjetPluginContenu> lireObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
        return this.getObjets(meta.getIdMetatag(), classeObjet);
    }

    @Override
    public void synchroniserObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
    }

    @Override
    public void dupliquerObjets(FicheUniv ficheUniv, Metatag meta, Long oldIdMeta, String classeObjet) throws Exception {
        this.ajouterObjets(ficheUniv, meta, this.getObjets(oldIdMeta, classeObjet), classeObjet);
    }

    @Override
    public void ajouterObjets(FicheUniv ficheUniv, Metatag meta, List<ObjetPluginContenu> listeObjet, String classeObjetCible) throws Exception {
        for (String classeObjet : this.getListeObjets(classeObjetCible)) {
            for (ObjetPluginContenu objetPluginContenu : listeObjet) {
                if (objetPluginContenu == null || !objetPluginContenu.getClass().getName().equals(classeObjet)) continue;
                objetPluginContenu.setIdMeta(meta.getIdMetatag());
                objetPluginContenu.add();
            }
        }
    }

    public List<String> getListeObjets(String classeObjetCible) {
        ArrayList<String> lstObjets = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)classeObjetCible)) {
            lstObjets.add(classeObjetCible);
        } else if (this.objets != null) {
            lstObjets.addAll(this.objets);
        }
        return lstObjets;
    }

    private List<ObjetPluginContenu> getObjets(Long idMeta, String classeObjetCible) throws Exception {
        ArrayList<ObjetPluginContenu> sousObjets = new ArrayList<ObjetPluginContenu>();
        for (String classeObjet : this.getListeObjets(classeObjetCible)) {
            Object objet = Class.forName(classeObjet).newInstance();
            if (!(objet instanceof ObjetPluginContenu)) continue;
            ObjetPluginContenu sousObjet = (ObjetPluginContenu)objet;
            ContexteDao ctxDao = new ContexteDao();
            Throwable throwable = null;
            try {
                sousObjet.setCtx(ctxDao);
                sousObjet.selectByMeta(idMeta);
                while (sousObjet.nextItem()) {
                    sousObjets.add(sousObjet.cloneObjet());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctxDao == null) continue;
                if (throwable != null) {
                    try {
                        ctxDao.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctxDao.close();
            }
        }
        return sousObjets;
    }

    @Override
    public void setDataContexteUniv(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
        ContexteUtil.getContexteUniv().putData(BeanUtil.getBeanKey(this.getId(), this.getIdExtension()), this.lireObjets(ficheUniv, meta, classeObjet));
    }

    @Override
    public Object getDataContexteUniv() {
        return ContexteUtil.getContexteUniv().getData(BeanUtil.getBeanKey(this.getId(), this.getIdExtension()));
    }

    @Override
    public String getPathTemplateFo() {
        return this.pathTemplateFo;
    }

    public void setPathTemplateFo(String pathTemplateF0) {
        this.pathTemplateFo = pathTemplateF0;
    }
}

