/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.objetspartages;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.plugin.objetspartages.IPluginFiche;
import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PluginFicheHelper {
    public static final int SAISIE_BO = 0;
    public static final int SAISIE_FO = 1;
    public static final int TEMPLATE_FO = 2;

    public static Collection<IPluginFiche> getPlugins() {
        return new ArrayList<IPluginFiche>(ModuleHelper.getModuleManager().getModules(IPluginFiche.class));
    }

    public static void preparerPrincipal(InfoBean infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!plugin.isActive(ficheUniv.getClass().getName())) continue;
            Map<String, Object> map = infoBean.getValues();
            plugin.preparerPrincipal(map, ficheUniv, meta);
            infoBean.setValues(map);
        }
    }

    public static void traiterPrincipal(InfoBean infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!plugin.isActive(ficheUniv.getClass().getName())) continue;
            Map<String, Object> map = infoBean.getValues();
            plugin.traiterPrincipal(map, ficheUniv, meta);
            infoBean.setValues(map);
        }
    }

    public static void preTraiterPrincipal(InfoBean infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!plugin.isActive(ficheUniv.getClass().getName())) continue;
            Map<String, Object> map = infoBean.getValues();
            plugin.preTraiterPrincipal(map, ficheUniv, meta);
            infoBean.setValues(map);
        }
    }

    public static void postTraiterPrincipal(InfoBean infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!plugin.isActive(ficheUniv.getClass().getName())) continue;
            Map<String, Object> map = infoBean.getValues();
            plugin.postTraiterPrincipal(map, ficheUniv, meta);
            infoBean.setValues(map);
        }
    }

    public static void supprimerObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!PluginFicheHelper.process(plugin, ficheUniv, classeObjet)) continue;
            plugin.supprimerObjets(ficheUniv, meta, classeObjet);
        }
    }

    public static void ajouterObjets(FicheUniv ficheUniv, Metatag meta, List<ObjetPluginContenu> listeObjet, String classeObjet) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!PluginFicheHelper.process(plugin, ficheUniv, classeObjet)) continue;
            plugin.ajouterObjets(ficheUniv, meta, listeObjet, classeObjet);
        }
    }

    public static void synchroniserObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!PluginFicheHelper.process(plugin, ficheUniv, classeObjet)) continue;
            plugin.synchroniserObjets(ficheUniv, meta, classeObjet);
        }
    }

    public static void synchroniserListeObjets(FicheUniv ficheUniv, Metatag meta, ArrayList<ObjetPluginContenu> lstObjets) throws Exception {
        List<ObjetPluginContenu> lstObjetsOld = PluginFicheHelper.lireObjets(ficheUniv, meta, null);
        ArrayList<ObjetPluginContenu> lstObjetsTemp = new ArrayList<ObjetPluginContenu>(lstObjets);
        block0: for (ObjetPluginContenu objetExistant : lstObjetsOld) {
            Iterator it = lstObjetsTemp.iterator();
            while (it.hasNext()) {
                ObjetPluginContenu nouvelObjet = (ObjetPluginContenu)it.next();
                if (!objetExistant.getCle().equals(nouvelObjet.getCle())) continue;
                nouvelObjet.setIdObjet(objetExistant.getIdObjet());
                nouvelObjet.setIdMeta(objetExistant.getIdMeta());
                nouvelObjet.update();
                it.remove();
                continue block0;
            }
        }
        PluginFicheHelper.ajouterObjets(ficheUniv, meta, lstObjetsTemp, null);
    }

    public static void dupliquerObjets(FicheUniv ficheUniv, Metatag meta, Long oldIdMeta, String classeObjet) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!PluginFicheHelper.process(plugin, ficheUniv, classeObjet)) continue;
            plugin.dupliquerObjets(ficheUniv, meta, oldIdMeta, classeObjet);
        }
    }

    public static List<ObjetPluginContenu> lireObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
        ArrayList<ObjetPluginContenu> sousObjets = new ArrayList<ObjetPluginContenu>();
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!PluginFicheHelper.process(plugin, ficheUniv, classeObjet)) continue;
            sousObjets.addAll(plugin.lireObjets(ficheUniv, meta, classeObjet));
        }
        return sousObjets;
    }

    public static Boolean hasPlugin(String classe, boolean isBO) {
        for (IPluginFiche controleur : PluginFicheHelper.getPlugins()) {
            String path;
            if (!controleur.isActive(classe) || !StringUtils.isNotEmpty((CharSequence)(path = isBO ? controleur.getPathSaisieBo() : controleur.getPathSaisieFo()))) continue;
            return true;
        }
        return false;
    }

    public static Boolean isObjetPlugin(String classeObjet, String classe) throws Exception {
        if (!(Class.forName(classe).newInstance() instanceof FicheUniv) || !(Class.forName(classeObjet).newInstance() instanceof ObjetPluginContenu)) {
            return false;
        }
        for (IPluginFiche controleur : PluginFicheHelper.getPlugins()) {
            if (!PluginFicheHelper.process(controleur, (FicheUniv)Class.forName(classe).newInstance(), classeObjet)) continue;
            return true;
        }
        return false;
    }

    private static boolean process(IPluginFiche plugin, FicheUniv ficheUniv, String classeObjet) {
        return plugin.isActive(ficheUniv.getClass().getName()) && plugin.hasObjet(classeObjet);
    }

    public static void setDataContexteUniv(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!PluginFicheHelper.process(plugin, ficheUniv, classeObjet)) continue;
            plugin.setDataContexteUniv(ficheUniv, meta, classeObjet);
        }
    }

    public static Collection<IPluginFiche> getPluginsByObjet(String name) {
        Collection<IPluginFiche> res = PluginFicheHelper.getPlugins();
        Iterator<IPluginFiche> it = res.iterator();
        while (it.hasNext()) {
            IPluginFiche next = it.next();
            if (!CollectionUtils.isEmpty(next.getObjets()) && next.getObjets().contains(name)) continue;
            it.remove();
        }
        return res;
    }

    public static Collection<IPluginFiche> getPluginsFromClass(String name) {
        Collection<IPluginFiche> res = PluginFicheHelper.getPlugins();
        Iterator<IPluginFiche> it = res.iterator();
        while (it.hasNext()) {
            IPluginFiche next = it.next();
            if (!CollectionUtils.isEmpty(next.getClasses()) && next.getClasses().contains(name)) continue;
            it.remove();
        }
        return res;
    }
}

