/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.objetspartages;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.plugin.objetspartages.IPluginRecherche;
import com.kportal.frontoffice.util.JSPIncludeHelper;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RequeteUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class PluginRechercheHelper {
    public static Collection<IPluginRecherche> getPlugins() {
        return ModuleHelper.getModuleManager().getModules(IPluginRecherche.class);
    }

    public static IPluginRecherche getPluginActif(String requete) {
        String objet = RequeteUtil.renvoyerParametre(requete, "OBJET");
        Object object = ReferentielObjets.instancierObjet(objet);
        if (object != null) {
            for (IPluginRecherche plugin : PluginRechercheHelper.getPlugins()) {
                if (!plugin.checkClasse(object.getClass().getName()) || !plugin.isActif(requete)) continue;
                return plugin;
            }
        }
        return null;
    }

    public static void traiterRecherche(OMContext ctx, InfoBean infoBean) throws Exception {
        String objet = infoBean.getString("CODE_OBJET");
        Object object = ReferentielObjets.instancierObjet(objet);
        for (IPluginRecherche plugin : PluginRechercheHelper.getPlugins()) {
            if (!plugin.checkClasse(object.getClass().getName())) continue;
            Map<String, Object> map = infoBean.getValues();
            plugin.taiterRecherche(ctx, map);
            infoBean.setValues(map);
        }
    }

    public static void preparerRecherche(OMContext ctx, InfoBean infoBean) throws Exception {
        String objet = infoBean.getString("CODE_OBJET");
        Object object = ReferentielObjets.instancierObjet(objet);
        for (IPluginRecherche plugin : PluginRechercheHelper.getPlugins()) {
            if (!plugin.checkClasse(object.getClass().getName())) continue;
            Map<String, Object> map = infoBean.getValues();
            plugin.preparerRecherche(ctx, map);
            infoBean.setValues(map);
        }
    }

    public static List<String> getCriteresRequete(String objet) {
        ArrayList<String> criteres = new ArrayList<String>();
        Object object = ReferentielObjets.instancierObjet(objet);
        for (IPluginRecherche plugin : PluginRechercheHelper.getPlugins()) {
            if (!plugin.checkClasse(object.getClass().getName())) continue;
            criteres.addAll(plugin.getCriteresRequete());
        }
        return criteres;
    }

    public static void includePluginRechercheBo(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String objet, boolean listeIncluse) {
        ContexteUtil.getContexteUniv().getDatas().put("listeIncluse", listeIncluse);
        Object object = ReferentielObjets.instancierObjet(objet);
        for (IPluginRecherche plugin : PluginRechercheHelper.getPlugins()) {
            if (!plugin.checkClasse(object.getClass().getName())) continue;
            JSPIncludeHelper.includeExtensionTemplate(out, context, request, response, plugin.getIdExtension(), plugin.getPathRechercheBo());
        }
    }
}

