/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.rubrique;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.DefaultPageAccueilRubrique;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.UnivWebFmt;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FichePageAccueilRubrique
extends DefaultPageAccueilRubrique {
    private static final long serialVersionUID = 6420883169765691077L;

    @Override
    public void preparerPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception {
        BeanFichePageAccueil b = (BeanFichePageAccueil)bean;
        FicheUniv ficheUniv = b.getFichePageTete(true);
        String typeFiche = ReferentielObjets.getLibelleObjet(b.objet);
        if (ficheUniv != null) {
            infoBean.put("LIBELLE_CODE_PAGE_TETE", typeFiche + " : " + ficheUniv.getLibelleAffichable());
        } else {
            infoBean.put("LIBELLE_CODE_PAGE_TETE", "");
        }
        infoBean.put("CODE_PAGE_TETE", b.getCodePageTete());
    }

    @Override
    public void traiterPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception {
        BeanFichePageAccueil b = (BeanFichePageAccueil)bean;
        if (StringUtils.isEmpty((CharSequence)((String)infoBean.get("CODE_PAGE_TETE")))) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("RUBRIQUE.PAGE_TETE.ERREUR.PAGE_TETE_OBLIGATOIRE"));
        }
        b.parseCodePageTete((String)infoBean.get("CODE_PAGE_TETE"));
        FicheUniv ficheUniv = b.getFichePageTete(true);
        if (ficheUniv != null && ficheUniv.getCodeRubrique().length() == 0) {
            ficheUniv.setCodeRubrique((String)infoBean.get("CODE"));
            ficheUniv.update();
            Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
            meta.setMetaCodeRubrique((String)infoBean.get("CODE"));
            FicheUnivMgr.enregistrerMeta(meta);
        }
    }

    public static class BeanFichePageAccueil
    implements BeanPageAccueil {
        private String code = "";
        private String langue = "";
        private String objet = "";

        public void setCode(String code) {
            this.code = code;
        }

        public void setLangue(String langue) {
            this.langue = langue;
        }

        public void setObjet(String objet) {
            this.objet = objet;
        }

        @Override
        public String getUrlRubrique(String codeRubrique, String codeLangue, boolean ampersands) throws Exception {
            return UnivWebFmt.determinerUrlFiche(ContexteUtil.getContexteUniv(), this.objet, this.code, this.langue, ampersands, codeRubrique);
        }

        @Override
        public String getUrlModification(String codeRubrique, String langue, boolean ampersands) throws Exception {
            if (ContexteUtil.getContexteUniv() != null) {
                AutorisationBean autorisation = ContexteUtil.getContexteUniv().getAutorisation();
                FicheUniv fiche = this.getFichePageTete(true);
                if (fiche != null && autorisation.estAutoriseAModifierLaFiche(fiche)) {
                    String esperluette = ampersands ? "&amp;" : "&";
                    return "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + ReferentielObjets.getExtension(fiche) + esperluette + "PROC=SAISIE_" + this.objet.toUpperCase() + esperluette + "ECRAN_LOGIQUE=LISTE" + esperluette + "ACTION=MODIFIER" + esperluette + "ID_FICHE=" + fiche.getIdFiche();
                }
            }
            return "";
        }

        private String getCodePageTete() {
            return StringUtils.isNotEmpty((CharSequence)this.code) ? this.code + ",LANGUE=" + this.langue + ",TYPE=" + this.objet : "";
        }

        public FicheUniv getFichePageTete(boolean all) throws Exception {
            FicheUniv ficheUniv = null;
            if (StringUtils.isNotEmpty((CharSequence)this.objet) && (ficheUniv = ReferentielObjets.instancierFiche(this.objet)) != null) {
                ficheUniv.init();
                ficheUniv.setCtx(ContexteUtil.getContexteUniv());
                if (ficheUniv.selectCodeLangueEtat(this.code, this.langue, "0003") > 0) {
                    ficheUniv.nextItem();
                } else if (all && ficheUniv.selectCodeLangueEtat(this.code, this.langue, "") > 0) {
                    ficheUniv.nextItem();
                }
            }
            return ficheUniv;
        }

        public void parseCodePageTete(String codePageTete) {
            this.code = codePageTete;
            this.langue = "0";
            this.objet = "pagelibre";
            int indiceLangue = codePageTete.indexOf(",LANGUE=");
            int indiceType = codePageTete.indexOf(",TYPE=");
            if (indiceLangue != -1) {
                this.langue = indiceType != -1 ? codePageTete.substring(indiceLangue + 8, indiceType) : codePageTete.substring(indiceLangue + 8);
                this.code = codePageTete.substring(0, indiceLangue);
            }
            if (indiceType != -1) {
                this.objet = codePageTete.substring(indiceType + 6);
            }
        }

        @Override
        public String getLibelleAffichable() {
            String res = ReferentielObjets.getLibelleObjet(this.objet);
            try {
                FicheUniv fiche = this.getFichePageTete(false);
                if (fiche != null) {
                    res = res + " - " + fiche.getLibelleAffichable();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return res;
        }

        public String getCode() {
            return this.code;
        }

        public String getLangue() {
            return this.langue;
        }

        public String getObjet() {
            return this.objet;
        }
    }
}

