/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.rubrique;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.DefaultPageAccueilRubrique;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ListeFichePageAccueilRubrique
extends DefaultPageAccueilRubrique {
    private static final long serialVersionUID = -6558789002484644694L;

    @Override
    public void preparerPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception {
        BeanListeFichePageAccueil b = (BeanListeFichePageAccueil)bean;
        if (StringUtils.isNotEmpty((CharSequence)b.objet)) {
            infoBean.put("CODE_OBJET_LISTE", b.objet);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(" ", "");
        Object nomObjet = null;
        for (Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
            if (objet.isCollaboratif()) continue;
            table.put(objet.getNomObjet(), objet.getLibelleObjet());
        }
        infoBean.put("LISTE_OBJET_LISTE", table);
    }

    @Override
    public void traiterPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception {
        BeanListeFichePageAccueil b = (BeanListeFichePageAccueil)bean;
        String codeObjet = (String)infoBean.get("CODE_OBJET_LISTE");
        if (StringUtils.isEmpty((CharSequence)codeObjet) || ReferentielObjets.instancierFiche(codeObjet) == null) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("RUBRIQUE.PAGE_TETE.ERREUR.OBJET_OBLIGATOIRE"));
        }
        b.objet = (String)infoBean.get("CODE_OBJET_LISTE");
    }

    public static class BeanListeFichePageAccueil
    implements BeanPageAccueil {
        private String objet = "";

        @Override
        public String getUrlRubrique(String codeRubrique, String langue, boolean ampersands) throws Exception {
            String esperluette = ampersands ? "&amp;" : "&";
            return UnivWebFmt.determinerUrlFiche(ContexteUtil.getContexteUniv(), this.objet, "CODE_RUBRIQUE=" + codeRubrique + esperluette + "LANGUE=" + langue + esperluette + "AFFICHAGE_DOSSIER=1", ampersands);
        }

        @Override
        public String getUrlModification(String codeRubrique, String langue, boolean ampersands) throws Exception {
            return "";
        }

        @Override
        public String getLibelleAffichable() {
            return ReferentielObjets.getLibelleObjet(this.objet);
        }

        public String getObjet() {
            return this.objet;
        }
    }
}

