/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.rubrique;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.extension.module.AbstractBeanManager;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.IPageAccueilRubrique;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import com.univ.url.CacheUrlManager;
import com.univ.utils.json.CodecJSon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageAccueilRubriqueManager
extends AbstractBeanManager {
    public static final String ID_BEAN = "pageAccueilRubriqueManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(PageAccueilRubriqueManager.class);
    private Map<String, IPageAccueilRubrique> typesRubrique;
    private CacheUrlManager cacheUrlManager;

    public static PageAccueilRubriqueManager getInstance() {
        return (PageAccueilRubriqueManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }

    @Override
    public void refresh() {
        this.typesRubrique = new HashMap<String, IPageAccueilRubrique>();
        Collection<IPageAccueilRubrique> pagesAccueil = this.moduleManager.getModules(IPageAccueilRubrique.class);
        for (IPageAccueilRubrique iModule : pagesAccueil) {
            if (this.typesRubrique.containsKey(iModule.getTypeRubrique())) {
                LOGGER.warn("Le type de rubrique " + iModule.getTypeRubrique() + " existe d\u00e9j\u00e0");
                continue;
            }
            this.typesRubrique.put(iModule.getTypeRubrique(), iModule);
        }
        this.cacheUrlManager.refresh();
    }

    public Hashtable<String, String> getListeTypesRubrique() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (String type : this.typesRubrique.keySet()) {
            h.put(type, this.getPageAccueilRubrique(type).getLibelleAffichable());
        }
        return h;
    }

    public Map<String, IPageAccueilRubrique> getTypesRubrique() {
        return this.typesRubrique;
    }

    public BeanPageAccueil getBeanPageAccueil(InfosRubriques rubrique) {
        return this.getBeanPageAccueil(rubrique.getTypeRubrique(), rubrique.getPageAccueil());
    }

    public BeanPageAccueil getBeanPageAccueil(String typeRubrique, String contenuPageAccueil) {
        IPageAccueilRubrique pageAccueil;
        BeanPageAccueil bean = null;
        if (StringUtils.isNotEmpty((CharSequence)contenuPageAccueil) && (pageAccueil = this.getPageAccueilRubrique(typeRubrique)) != null) {
            try {
                bean = (BeanPageAccueil)CodecJSon.decodeStringJSonToClass(contenuPageAccueil, Class.forName(pageAccueil.getClasseBeanPageAccueil()));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("impossible de r\u00e9cup\u00e9rer le bean de page d'accueil pour la classe " + pageAccueil.getClasseBeanPageAccueil(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Erreur lors du traitement du JSON", (Throwable)e);
            }
        }
        return bean;
    }

    public void setTypesRubrique(Map<String, IPageAccueilRubrique> typesRubrique) {
        this.typesRubrique = typesRubrique;
    }

    public void preparerPRINCIPAL(InfoBean infoBean, Rubrique rubrique) throws Exception {
        for (IPageAccueilRubrique pageAccueil : this.typesRubrique.values()) {
            BeanPageAccueil bean = (BeanPageAccueil)Class.forName(pageAccueil.getClasseBeanPageAccueil()).newInstance();
            if (pageAccueil.getTypeRubrique().equals(rubrique.getTypeRubrique()) && StringUtils.isNotBlank((CharSequence)rubrique.getPageAccueil())) {
                bean = (BeanPageAccueil)CodecJSon.decodeStringJSonToClass(rubrique.getPageAccueil(), bean.getClass());
                infoBean.set("URL_APERCU", bean.getUrlRubrique(rubrique.getCode(), rubrique.getLangue(), true));
            }
            Map<String, Object> map = infoBean.getValues();
            pageAccueil.preparerPRINCIPAL(map, bean);
            infoBean.setValues(map);
            infoBean.set("TYPE_RUBRIQUE", rubrique.getTypeRubrique());
        }
    }

    public void traiterPRINCIPAL(InfoBean infoBean, Rubrique rubrique) throws Exception {
        String typeRubrique = (String)infoBean.get("TYPE_RUBRIQUE");
        IPageAccueilRubrique pageAccueil = this.getPageAccueilRubrique(typeRubrique);
        if (pageAccueil != null) {
            Map<String, Object> map = infoBean.getValues();
            BeanPageAccueil bean = (BeanPageAccueil)Class.forName(pageAccueil.getClasseBeanPageAccueil()).newInstance();
            pageAccueil.traiterPRINCIPAL(map, bean);
            infoBean.setValues(map);
            rubrique.setPageAccueil(CodecJSon.encodeObjectToJSonInString(bean));
            rubrique.setTypeRubrique(typeRubrique);
        } else {
            rubrique.setPageAccueil("");
            rubrique.setTypeRubrique("");
        }
    }

    public boolean isInterne(InfosRubriques rubrique) {
        return this.getPageAccueilRubrique(rubrique.getTypeRubrique()) == null || this.getPageAccueilRubrique(rubrique.getTypeRubrique()).isInterne(this.getBeanPageAccueil(rubrique));
    }

    public IPageAccueilRubrique getPageAccueilRubrique(String typeRubrique) {
        return this.typesRubrique.get(typeRubrique);
    }

    public String getTypePageAcceuilParBeanPageAccueil(BeanPageAccueil pageAccueil) {
        String codeTypeRubrique = "";
        for (Map.Entry<String, IPageAccueilRubrique> typeRubrique : this.typesRubrique.entrySet()) {
            if (!typeRubrique.getValue().getClasseBeanPageAccueil().equals(pageAccueil.getClass().getName())) continue;
            codeTypeRubrique = typeRubrique.getKey();
        }
        return codeTypeRubrique;
    }

    public void setCacheUrlManager(CacheUrlManager cacheUrlManager) {
        this.cacheUrlManager = cacheUrlManager;
    }
}

