/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.rubrique;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.DefaultPageAccueilRubrique;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.utils.ContexteUtil;
import com.univ.utils.ServicesUtil;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ServicePageAccueilRubrique
extends DefaultPageAccueilRubrique {
    private static final long serialVersionUID = 7746055689577755034L;

    @Override
    public void preparerPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception {
        BeanServicePageAccueil b = (BeanServicePageAccueil)bean;
        if (StringUtils.isNotEmpty((CharSequence)b.code)) {
            infoBean.put("CODE_SERVICE", b.code);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(" ", "");
        for (ServiceBean service : ServicesUtil.getServices().values()) {
            table.put(service.getCode(), service.getIntitule());
        }
        infoBean.put("LISTE_SERVICES", table);
    }

    @Override
    public void traiterPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception {
        BeanServicePageAccueil b = (BeanServicePageAccueil)bean;
        String codeService = (String)infoBean.get("CODE_SERVICE");
        if (StringUtils.isEmpty((CharSequence)codeService)) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("RUBRIQUE.PAGE_TETE.ERREUR.SERVICE_OBLIGATOIRE"));
        }
        b.code = (String)infoBean.get("CODE_SERVICE");
    }

    @Override
    public boolean isInterne(BeanPageAccueil bean) {
        if (bean instanceof BeanServicePageAccueil) {
            try {
                ServiceBean service = ServicesUtil.getService(((BeanServicePageAccueil)bean).getCode());
                if (service != null) {
                    if (service.getVueReduiteType().equals("0")) {
                        return !service.getUrl().startsWith("http");
                    }
                    return StringUtils.isNotEmpty((CharSequence)service.getVueReduiteCtx());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.isInterne(bean);
    }

    public static class BeanServicePageAccueil
    implements BeanPageAccueil {
        private String code = "";

        @Override
        public String getUrlRubrique(String codeRubrique, String langue, boolean ampersands) throws Exception {
            ServiceBean service = ServicesUtil.getService(this.code);
            if (service != null) {
                return ServicesUtil.determinerUrlServiceTypeUrl(ContexteUtil.getContexteUniv(), service);
            }
            return "";
        }

        @Override
        public String getUrlModification(String codeRubrique, String langue, boolean ampersands) throws Exception {
            return "/servlet/com.jsbsoft.jtf.core.SG?EXT=core&PROC=SAISIE_PREFERENCES&ACTION=MODIFIERPARCODE&CODE_SERVICE=" + this.code;
        }

        @Override
        public String getLibelleAffichable() {
            String libelle = "";
            try {
                ServiceBean service = ServicesUtil.getService(this.code);
                libelle = libelle + service.getIntitule();
            }
            catch (Exception e) {
                libelle = libelle + "Inconnu";
            }
            return libelle;
        }

        public String getCode() {
            return this.code;
        }
    }
}

