/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.plugin.toolbox;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.plugin.toolbox.IPluginToolbox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PluginToolboxHelper {
    public static String getRelativePath(IPluginToolbox pluginToolbox) {
        return ModuleHelper.getRelativePathExtension(pluginToolbox) + pluginToolbox.getPath();
    }

    public static Collection<IPluginToolbox> getPlugins() {
        return ModuleHelper.getModuleManager().getModules(IPluginToolbox.class);
    }

    public static String getConfiguration(InfoBean infoBean) {
        String res = "";
        Collection<IPluginToolbox> plugins = PluginToolboxHelper.getPlugins();
        if (plugins.size() > 0) {
            for (IPluginToolbox iModule : plugins) {
                if (!PluginToolboxHelper.isVisible(iModule, infoBean)) continue;
                if (res.length() > 0) {
                    res = res + "|";
                }
                String path = PluginToolboxHelper.getRelativePath(iModule);
                res = res + StringUtils.substringAfterLast((String)path, (String)"/") + "," + StringUtils.substringBeforeLast((String)path, (String)"/") + "/";
            }
        }
        return res;
    }

    public static List<Pair<String, String>> getOptions(InfoBean infoBean) {
        ArrayList<Pair<String, String>> res = new ArrayList<Pair<String, String>>();
        Collection<IPluginToolbox> plugins = PluginToolboxHelper.getPlugins();
        if (plugins.size() > 0) {
            for (IPluginToolbox iModule : plugins) {
                if (!PluginToolboxHelper.isVisible(iModule, infoBean) || iModule.getOptions().isEmpty()) continue;
                for (Map.Entry<String, String> option : iModule.getOptions().entrySet()) {
                    res.add((Pair<String, String>)new ImmutablePair((Object)option.getKey(), (Object)option.getValue()));
                }
            }
        }
        return res;
    }

    private static boolean isVisible(IPluginToolbox plugin, InfoBean infoBean) {
        return plugin.isAccessible() && (plugin.getProcessus().isEmpty() || plugin.getProcessus().contains(infoBean.getNomProcessus()));
    }
}

