/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.service.impl;

import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.plugin.objetspartages.IPluginFiche;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheObjet;
import com.kportal.extension.module.service.ServiceContenuModule;
import com.kportal.extension.module.service.impl.DefaultServiceContenuModule;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.processus.ControleurFichiergw;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class PluginFicheServiceContenuModule
extends DefaultServiceContenuModule {
    public static final String PARAM_META_CODE_OBJET = "META_CODE_OBJET=";
    public static final String PARAM_CLASSE = "CLASSE=";

    @Override
    public void init() {
        this.modules = PluginFicheHelper.getPlugins();
        for (IPluginFiche plugin : PluginFicheHelper.getPlugins()) {
            if (!plugin.getClass().isAssignableFrom(ControleurFichiergw.class) && !(plugin instanceof PluginFicheObjet) && !CollectionUtils.isEmpty(plugin.getObjets()) && (plugin.getClasses() == null || !plugin.getClasses().isEmpty())) continue;
            this.modules.remove(plugin);
        }
    }

    @Override
    public ServiceContenuModule.TypeContenu getTypeContenu() {
        return ServiceContenuModule.TypeContenu.TECHNIQUE;
    }

    @Override
    public String[] recupereParamsExport(IModule moduleAExporter, Collection<IModule> modulesExportes) {
        Object[] paramsExport = null;
        if (this.modules.contains(moduleAExporter)) {
            IPluginFiche plugin = (IPluginFiche)moduleAExporter;
            if (plugin.getClasses() != null) {
                for (String nomClasse : plugin.getClasses()) {
                    Objetpartage moduleObjet = ReferentielObjets.getObjetByCode(ReferentielObjets.getCodeObjetParClasse(nomClasse));
                    if (!modulesExportes.contains(moduleObjet)) continue;
                    paramsExport = (String[])ArrayUtils.add((Object[])paramsExport, (Object)(PARAM_META_CODE_OBJET + moduleObjet.getCodeObjet()));
                }
            } else {
                for (IModule module : modulesExportes) {
                    if (!(module instanceof Objetpartage)) continue;
                    paramsExport = (String[])ArrayUtils.add(paramsExport, (Object)(PARAM_META_CODE_OBJET + ((Objetpartage)module).getCodeObjet()));
                }
            }
            if (ArrayUtils.isNotEmpty(paramsExport)) {
                for (String objet : plugin.getObjets()) {
                    paramsExport = (String[])ArrayUtils.add((Object[])paramsExport, (Object)(PARAM_CLASSE + objet));
                }
            }
        }
        return paramsExport;
    }
}

