/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.service.impl.beandeletion;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.extension.module.service.ServiceBeanDeletion;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteDao;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class ServiceBeanDeletionFiche
implements ServiceBeanDeletion {
    @Override
    public void deleteByRubrique(Collection<String> codesRubrique, String ... params) throws Exception {
        if (params == null || StringUtils.isEmpty((CharSequence)params[0])) {
            throw new ErreurApplicative("impossible de supprimer les fiches des rubriques sans sp\u00e9cifier le type de fiche \u00e0 supprimer");
        }
        Metatag metatag = new Metatag();
        metatag.init();
        ClauseWhere where = new ClauseWhere();
        where.setPremiereCondition(ConditionHelper.in("T1.META_CODE_RUBRIQUE", codesRubrique));
        where.and(ConditionHelper.egalVarchar("T1.META_CODE_OBJET", params[0]));
        try (ContexteDao ctxMeta = new ContexteDao();){
            metatag.setCtx(ctxMeta);
            metatag.select(where.formaterSQL());
            while (metatag.nextItem()) {
                ContexteDao ctxFiche = new ContexteDao();
                Throwable throwable = null;
                try {
                    FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(metatag.getMetaCodeObjet()));
                    fiche.setCtx(ctxFiche);
                    fiche.setIdFiche(metatag.getMetaIdFiche());
                    fiche.retrieve();
                    FicheUnivMgr.supprimerFiche(fiche, metatag);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctxFiche == null) continue;
                    if (throwable != null) {
                        try {
                            ctxFiche.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctxFiche.close();
                }
            }
        }
    }
}

