/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.service.impl.beanexport;

import com.jsbsoft.jtf.database.OMContext;
import com.kosmos.usinesite.utils.UASOmHelper;
import com.kosmos.usinesite.utils.UASServicesHelper;
import com.kportal.extension.module.bean.BeanExportMap;
import com.kportal.extension.module.bean.FicheBeanExport;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.bean.RubriquepublicationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class ServiceBeanExportFiche
implements ServiceBeanExport<FicheBeanExport<?>> {
    @Override
    public BeanExportMap<FicheBeanExport<?>> getBeansByRubrique(List<String> codesRubrique, String idModule, String pathExport, String ... params) throws Exception {
        BeanExportMap fichesBeans = new BeanExportMap();
        try (ContexteDao ctx = new ContexteDao();){
            Metatag metatag = new Metatag();
            metatag.init();
            metatag.setCtx(ctx);
            RequeteSQL requete = new RequeteSQL();
            ClauseWhere where = new ClauseWhere();
            where.setPremiereCondition(ConditionHelper.in("T1.META_CODE_RUBRIQUE", codesRubrique));
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.getParam(params, 0)})) {
                where.and(ConditionHelper.egalVarchar("T1.META_CODE_OBJET", params[0]));
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.getParam(params, 1)})) {
                where.and(ConditionHelper.egalVarchar("T1.META_ETAT_OBJET", params[1]));
            }
            requete.where(where);
            metatag.select(requete.formaterRequete());
            while (metatag.nextItem()) {
                this.processContent(ctx, idModule, metatag, codesRubrique, fichesBeans, pathExport);
            }
        }
        return fichesBeans;
    }

    private String getParam(String[] params, int index) {
        if (params.length > index) {
            return params[index];
        }
        return "";
    }

    public void processContent(OMContext ctx, String idModule, Metatag metatag, List<String> codesRubriquesExportees, Map<String, FicheBeanExport<?>> fichesBeans, String pathExport) throws Exception {
        FicheUniv ficheUniv;
        String typeObjet = ReferentielObjets.getNomObjet(metatag.getMetaCodeObjet());
        String codeFiche = metatag.getMetaCode();
        String langue = metatag.getMetaLangue();
        if (!fichesBeans.containsKey(typeObjet + "," + codeFiche + "," + langue) && (ficheUniv = ReferentielObjets.instancierFiche(typeObjet)) != null) {
            ficheUniv.setCtx(ctx);
            ficheUniv.init();
            if (ficheUniv.selectCodeLangueEtat(codeFiche, langue, metatag.getMetaEtatObjet()) > 0) {
                ficheUniv.nextItem();
                FicheBeanExport beanExport = UASServicesHelper.getFicheBeanExport(ficheUniv, UASServicesHelper.getBeanClass(ficheUniv));
                beanExport.setTypeObjet(typeObjet);
                beanExport.setIdModule(idModule);
                MetatagBean metatagBean = new MetatagBean();
                UASOmHelper.copyProperties(metatagBean, metatag);
                beanExport.setMetatag(metatagBean);
                Rubriquepublication rubpub = new Rubriquepublication();
                rubpub.setCtx(ctx);
                rubpub.init();
                int nbRubpub = rubpub.select(ReferentielObjets.getCodeObjet(typeObjet), ficheUniv.getCode(), ficheUniv.getLangue());
                ArrayList<RubriquepublicationBean> listeRubpub = new ArrayList<RubriquepublicationBean>(nbRubpub);
                while (rubpub.nextItem()) {
                    if (!codesRubriquesExportees.contains(rubpub.getRubriqueDest())) continue;
                    RubriquepublicationBean rubriquePublicationBean = new RubriquepublicationBean();
                    UASOmHelper.copyProperties(rubriquePublicationBean, rubpub);
                    listeRubpub.add(rubriquePublicationBean);
                }
                beanExport.setRubriquespublication(listeRubpub);
                Vector<Ressource> vRessources = Ressource.getListeTotale(ficheUniv);
                Map<String, MediaBean> medias = UASServicesHelper.getMediasByRessources(vRessources, pathExport);
                medias.putAll(UASServicesHelper.getMedias(ctx, ficheUniv, pathExport, Boolean.FALSE));
                beanExport.setRessources(UASServicesHelper.getRessources(vRessources));
                beanExport.setMedias(medias);
                fichesBeans.put(typeObjet + "," + codeFiche + "," + langue, beanExport);
            }
        }
    }
}

