/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.service.impl.beanexport;

import com.kosmos.usinesite.utils.UASServicesHelper;
import com.kportal.extension.module.bean.BeanExportMap;
import com.kportal.extension.module.bean.PluginFicheBeanExport;
import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.kportal.extension.module.plugin.objetspartages.om.SousObjet;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.univ.objetspartages.om.Metatag;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceBeanExportPluginFiche
implements ServiceBeanExport<PluginFicheBeanExport<?>> {
    @Override
    public BeanExportMap<PluginFicheBeanExport<?>> getBeansByRubrique(List<String> codesRubrique, String idModule, String pathExport, String ... params) throws Exception {
        BeanExportMap pluginFichesBeans = new BeanExportMap();
        if (ArrayUtils.isNotEmpty((Object[])params)) {
            ArrayList<String> codesObjet = new ArrayList<String>();
            ArrayList<String> classes = new ArrayList<String>();
            for (String param : params) {
                if (param.startsWith("META_CODE_OBJET=")) {
                    codesObjet.add(StringUtils.substringAfter((String)param, (String)"META_CODE_OBJET="));
                    continue;
                }
                if (!param.startsWith("CLASSE=")) continue;
                classes.add(StringUtils.substringAfter((String)param, (String)"CLASSE="));
            }
            if (CollectionUtils.isNotEmpty(classes)) {
                try (ContexteDao ctx = new ContexteDao();){
                    ArrayList<String> idsMeta = new ArrayList<String>();
                    Metatag metatag = new Metatag();
                    metatag.init();
                    metatag.setCtx(ctx);
                    RequeteSQL requete = new RequeteSQL();
                    ClauseWhere where = new ClauseWhere();
                    where.setPremiereCondition(ConditionHelper.in("T1.META_CODE_RUBRIQUE", codesRubrique));
                    if (CollectionUtils.isNotEmpty(codesObjet)) {
                        where.and(ConditionHelper.in("T1.META_CODE_OBJET", codesObjet));
                    }
                    requete.where(where);
                    metatag.select(requete.formaterRequete());
                    while (metatag.nextItem()) {
                        idsMeta.add(metatag.getIdMetatag().toString());
                    }
                    for (String classeObjet : classes) {
                        Class<?> clazz = Class.forName(classeObjet);
                        Object object = clazz.newInstance();
                        if (!(object instanceof ObjetPluginContenu)) continue;
                        ObjetPluginContenu objetPluginContenu = (ObjetPluginContenu)object;
                        objetPluginContenu.init();
                        objetPluginContenu.setCtx(ctx);
                        requete = new RequeteSQL();
                        where = new ClauseWhere();
                        where.setPremiereCondition(ConditionHelper.in("T1.ID_META", idsMeta));
                        requete.where(where);
                        objetPluginContenu.select(requete.formaterRequete());
                        while (objetPluginContenu.nextItem()) {
                            PluginFicheBeanExport beanExport = UASServicesHelper.getPluginFicheBeanExport(objetPluginContenu, UASServicesHelper.getBeanClass(objetPluginContenu));
                            beanExport.setClasseObjet(classeObjet);
                            beanExport.setIdModule(idModule);
                            beanExport.setMedias(UASServicesHelper.getMedias(ctx, objetPluginContenu, pathExport));
                            pluginFichesBeans.put(objetPluginContenu.getIdObjet().toString(), beanExport);
                            if (!CollectionUtils.isNotEmpty(objetPluginContenu.getSousObjets())) continue;
                            for (SousObjet sousObjet : objetPluginContenu.getSousObjets()) {
                                PluginFicheBeanExport<SousObjet> beanExportSousObjet = new PluginFicheBeanExport<SousObjet>();
                                String saveId = sousObjet.getIdObjet().toString();
                                sousObjet.setIdObjet(0L);
                                beanExportSousObjet.setBean(sousObjet);
                                beanExportSousObjet.setIdModule(idModule);
                                beanExportSousObjet.setClasseObjet(sousObjet.getClass().getName());
                                beanExportSousObjet.setMedias(UASServicesHelper.getMedias(ctx, sousObjet, pathExport));
                                pluginFichesBeans.put(sousObjet.getClass().getSimpleName() + saveId, beanExportSousObjet);
                            }
                        }
                    }
                }
            }
        }
        return pluginFichesBeans;
    }
}

