/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.service.impl.beanexport;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kosmos.usinesite.utils.UASServicesHelper;
import com.kportal.extension.module.bean.BeanExportMap;
import com.kportal.extension.module.bean.RubriqueBeanExport;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.bean.RubriqueBean;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.List;

public class ServiceBeanExportRubrique
implements ServiceBeanExport<RubriqueBeanExport> {
    @Override
    public BeanExportMap<RubriqueBeanExport> getBeansByRubrique(List<String> codesRubrique, String idModule, String pathExport, String ... params) throws Exception {
        BeanExportMap<RubriqueBeanExport> rubriqueBeans = new BeanExportMap<RubriqueBeanExport>();
        try (ContexteDao ctx = new ContexteDao();){
            Rubrique rubrique = new Rubrique();
            rubrique.setCtx(ctx);
            RequeteSQL requete = new RequeteSQL();
            ClauseWhere where = new ClauseWhere();
            where.setPremiereCondition(ConditionHelper.in("CODE", codesRubrique));
            requete.where(where);
            rubrique.select(requete.formaterRequete());
            while (rubrique.nextItem()) {
                RubriqueBean rubriqueBean = new RubriqueBean();
                RubriqueBeanExport rubriqueBeanExport = new RubriqueBeanExport();
                InfosSite infos = Site.renvoyerItemSiteParRubrique(rubrique.getCode());
                if (infos != null) {
                    rubriqueBeanExport.setRubriqueSite(true);
                }
                UASOmHelper.copyProperties(rubriqueBean, rubrique);
                rubriqueBeanExport.setIdModule(idModule);
                rubriqueBeanExport.setBean(rubriqueBean);
                rubriqueBeanExport.setMedias(UASServicesHelper.getMedias(ctx, rubrique, pathExport));
                rubriqueBeans.put(rubrique.getCode(), rubriqueBeanExport);
            }
        }
        return rubriqueBeans;
    }
}

